# BEGIN SourceDeps(oneline):
BuildRequires: perl(Data/Alias.pm) perl(ExtUtils/MakeMaker.pm) perl(List/MoreUtils.pm) perl(Regexp/Exhaustive.pm) perl(Regexp/Grammars.pm) perl(Test/More.pm) perl(common/sense.pm) perl(re.pm)
# END SourceDeps(oneline)
%define module_version 0.101
%define module_name Bio-Regexp
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.101
Release: alt1
Summary: Exhaustive DNA/RNA/protein regexp searches
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/F/FR/FRACTAL/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
This module is for searching inside DNA or RNA or protein sequences. The sequence to be found is specified by a restricted version of regular expressions. The restrictions allow us to manipulate the regexp in various ways described below. As well as regular expression character classes, bases can be expressed in IUPAC short form (which are kind of like character classes themselves).

The goal of this module is to provide a complete search. Given the particulars of a sequence (DNA/RNA/protein, linear molecule/circular plasmid, single/double stranded) it attempts to figure out all of the possible matches without any false-positive or duplicated matches.

It handles cases where matches overlap in the sequence and cases where the regular expression can match in multiple ways. For circular DNA (plasmids) it will find matches even if they span the arbitrary location in the circular sequence selected as the "start". For double-stranded DNA it will find matches on the reverse complement strand as well.

The typical use case of this module is to search for multiple small patterns in large amounts of input data. Although it is optimised for that task it is also efficient at others. For efficiency, none of the input sequence data is copied at all except to extract matches (but this can be disabled with `no_substr') and to implement circular searches (though the amount copied is usually very small).




%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/B*

%changelog
