%filter_from_requires /^perl.arybase.pm./d
%define module_version 0.11
%define module_name Bio-SDRS
%define _without_test 1
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(Inline.pm) perl(Inline/C.pm) perl(Math/NumberCruncher.pm) perl(Statistics/Distributions.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.11
Release: alt2
Summary: Perl extension for Sigmoidal Dose Response Search, a tool
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/B/BR/BRUC/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
Bio::SDRS implements the Sigmoidal Dose Response Search of assay responses
described in the paper by

Rui-Ru Ji, Nathan O. Siemers, Lei Ming, Liang Schweizer, and Robert E
Bruccoleri.

The module is implemented using a simple object oriented paradigm
where the object stores all the information needed for a calculation
along with a state variable, `STATE'. The state variable has three
possible values, `'setup'', `'calculating'' and `'calculated''. The
value of `'setup'' indicates that the object is being setup with
data, and any results in the object are inconsistent with the data.
The value of `'calculating'' indicates the object's computations are
in progress and tells the code not to delete intermediate files. This
object runs in parallel, and the object destruction code gets called
when each thread exits. Intermediate files must be protected at that
time.  The value of `'calculated'' indicates that the object's
computational results are consistent with the data, and may be
returned to a calling program.

The `'calculate'' method is used to update all the calculated values
from the input data. It checks the state variable first, and only does
the calculation if the state is `'setup''. Once the calculations are
complete, then the state variable is set to `'calculated''. Thus, the
`calculate' method can be called whenever a calculated value is
needed, and there is no performance penalty.

The module initializes the `Bio::SDRS' object with a state of
`'setup''. Any data input sets the state to `'setup''. Any requests
for calculated data, calls `'calculate'', which updates the state
variable so futures requests for calculated data return quickly.

N.B. This module uses parallel programming via a fork call to get
high performance.  *You must close all database connections prior to
calling the `calculate' method, and reopen them afterwards. In
addition, you must ensure that any automated DESTROY methods take in
account their execution when the child processes terminated.*

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %name = %{?epoch:%epoch:}%version-%release

%description scripts
scripts for %module_name


%prep
%setup -n %{module_name}-%{module_version}

%build
%perl_vendor_build INSTALLMAN1DIR=%_man1dir

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/B*

%files scripts
%_bindir/*
%_man1dir/*

%changelog
