# BEGIN SourceDeps(oneline):
BuildRequires: perl(Bio/Root/Root.pm) perl(Bio/Root/Test.pm) perl(Bio/SearchIO.pm) perl(Bio/SearchIO/IteratedSearchResultEventBuilder.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(IO/File.pm) perl(IO/Handle.pm) perl(IPC/Open3.pm) perl(Pod/Coverage/TrustPod.pm) perl(Test/EOL.pm) perl(Test/Mojibake.pm) perl(Test/More.pm) perl(Test/NoTabs.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(Time/HiRes.pm) perl(XML/SAX.pm) perl(XML/SAX/Base.pm) perl(base.pm) perl(lib.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define module_name Bio-SearchIO-blastxml
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.70
Release: alt1
Summary: A SearchIO implementation of NCBI Blast XML parsing.
Group: Development/Perl
License: perl
URL: https://metacpan.org/release/Bio-SearchIO-blastxml

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/C/CJ/CJFIELDS/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This object implements a NCBI Blast XML parser.  It requires XML::SAX; it is
also recommended (for faster parsing) that XML::SAX::ExpatXS or XML::LibXML
be installed.  Either 'XML::SAX::ExpatXS' or 'XML::LibXML::SAX::Parser' should
be set as the default parser in ParserDetails.ini.  This file is located in the
SAX subdirectory of XML in your local perl library (normally in the 'site'
directory).

Two different XML handlers currently exist to deal with logical differences
between how normal BLAST reports and PSI-BLAST reports are logically parsed into
BioPerl objects; this is explicitly settable using the -blasttype parameter.
The default is for parsing a normal BLAST report ('blast'), but if one is
expecting PSI-BLAST report parsing, -blasttype must be set explicitly to
'psiblast'. This is due to a lack of any information in the XML output which
tells the parser the report is derived from a PSI-BLAST run vs. a normal BLAST
run.

There is one additional initialization flag from the SearchIO defaults. That is
the -tempfile flag. If specified as true, then the parser will write out each
report to a temporary filehandle rather than holding the entire report as a
string in memory. The reason this is done in the first place is NCBI reports
have an uncessary <?xml version="1.0"?> at the beginning of each report
and RPS-BLAST reports have an additional unnecessary RPS-BLAST tag at the top of
each report. So we currently have implemented the work around by preparsing the
file (yes it makes the process slower, but it works). We are open to suggestions
on how to optimize this in the future.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes LICENSE README.md
%perl_vendor_privlib/B*

%changelog
