# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(Test/More.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define module_name Bio-SeqAlignment
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.02
Release: alt1
Summary: Aligning (and pseudo aligning) biological sequences
Group: Development/Perl
License: perl
URL: https://github.com/chrisarg/bio-seqalignment

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/C/CH/CHRISARG/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
The Bio::SeqAlignment distribution provides a wrapper over collection of
tools, static and dynamic libraries for (pseudo-)aligning biological.
sequences. The overarching aim is to provide a Perl ecosystem that can
be used to build components that can be integrated in pipelines and 
workflows (e.g. nextflow, snakemake, etc) for sequencing experiments, or
stand alone Perl applications that can utilize an extremely rich ecosystem
of Perl modules and libraries for bioinformatics. 

Perl had always been a very strong language for wrapping external tools,
to create a seamless experience for the programmer and the emergence of
the Alien namespace has made it even easier to handle dependencies on 
external tools and libraries. Modules that are part of the Bio::SeqAlignment
distribution may be classified as:

=over 4

=item * External Command Line Tools

=item * External Libraries

=item * Components (modules) for building Perl applications

=item * Perl Applications

=item * Examples and Tutorials

=back

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README LICENSE
%perl_vendor_privlib/B*

%changelog
