# BEGIN SourceDeps(oneline):
BuildRequires: perl(Bio/SeqAlignment/Components/Sundry/DocumentSequenceModifications.pm) perl(Bio/SeqAlignment/Components/Sundry/IOHelpers.pm) perl(Bio/SeqAlignment/Components/Sundry/Tailing.pm) perl(Data/MessagePack.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Basename.pm) perl(File/Spec.pm) perl(FindBin.pm) perl(Getopt/Long.pm) perl(JSON.pm) perl(Test/More.pm) perl(YAML/Tiny.pm) perl(constant.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define module_name Bio-SeqAlignment-Applications-SequencingSimulators-RNASeq-Polyester
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.02
Release: alt1
Summary: Skeleton package that does nothing but reserve the namespace.
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/C/CH/CHRISARG/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
The purpose of the application is to enhance the polyester RNA sequencing
simulation tool by including polyA tails in the reference RNA being used to
generate the simulated  sequencing data. The application is a wrapper around
the R package polyester, which only accounts for the processes of fragmentation,
reverse complementation and sequencing when generating data. 
Note that the Perl application does not (at this moment) include the possibility
of passing logspline R objects as parameters to the R script and the the 
polyester "simulate_experiment" function.
The command line options are the same as the ones in the polyester R package,
with the exception of:
* The addition of the --taildist option, which is mandatory and specifies
the tail distribution to be used.
* The addition of the --distparams option, which is mandatory and specifies
the parameters of the distribution.
* The addition of the --maxseqs option, which is optional and specifies
whether to break the single fasta file generated by the application into
multiple files of a specified maximum number of sequences.
* The addition of the --modformat option, which is optional and specifies
the format for storing modifications (one of JSON, YAML, or MessagePack).
* BONUS: provide a R script that can be used to control the polyester
  simulation process from the command line (polyester.R)
All other parameters have the same interpretation and semantics as in the
polyester R package.

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %name = %EVR

%description scripts
scripts for %module_name

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README LICENSE
%perl_vendor_privlib/B*

%files scripts
%_bindir/*

%changelog
