# BEGIN SourceDeps(oneline):
BuildRequires: perl(Bio/Root/Test.pm) perl(Bio/SeqIO.pm) perl(Bio/SeqIO/table.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(IO/Handle.pm) perl(IPC/Open3.pm) perl(Pod/Coverage/TrustPod.pm) perl(Spreadsheet/ParseExcel.pm) perl(Test/Mojibake.pm) perl(Test/More.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(base.pm) perl(lib.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define module_name Bio-SeqIO-excel
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.7.3
Release: alt1
Summary: sequence input/output stream from a MSExcel-formatted table
Group: Development/Perl
License: perl
URL: https://metacpan.org/release/Bio-SeqIO-excel

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/C/CJ/CJFIELDS/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This class transforms records in a MS Excel workbook file into
Bio::Seq objects. It is derived from the table format module and
merely defines additional properties and overrides the way to get data
from the file and advance to the next record.

The module permits specifying which columns hold which type of
annotation. The semantics of certain attributes, if present, are
pre-defined, e.g., accession number and sequence. Additional
attributes may be added to the annotation bundle. See
the Bio::SeqIO::table manpage for a complete list of parameters and
capabilities.

You may also specify the worksheet from which to obtain the data, and
after finishing one worksheet you may change the name to keep reading
from another worksheet (in the same file).

This module depends on Spreadsheet::ParseExcel to parse the underlying
Excel file.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes LICENSE
%perl_vendor_privlib/B*

%changelog
