# BEGIN SourceDeps(oneline):
BuildRequires: perl(Bio/DB/GenBank.pm) perl(Bio/PrimarySeq.pm) perl(Bio/Root/Root.pm) perl(Bio/SeqIO.pm) perl(Bio/Tools/CodonTable.pm) perl(Bio/Tools/SeqStats.pm) perl(Data/Dumper.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Slurp.pm) perl(GD/Graph/bars.pm) perl(LWP/UserAgent.pm) perl(Test/More.pm) perl(Text/Textile.pm) perl(URI/Escape.pm)
# END SourceDeps(oneline)
%define module_name Bio-Tools-CodonOptTable
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.05
Release: alt1
Summary: A more elaborative way to check the codons usage!
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/S/SH/SHARDIWAL/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
The purpose of this module is to show codon usage.

We produces each codon frequency,
_    Relative Synonymous Codons Uses and
_    Relative Adaptiveness of a Codon table and bar graph
that will help you to calculate the Codon Adaptation Index (CAI) of a gene, to see the gene expression level.

Relative Synonymous Codons Uses(RSCU) values are the number of times a particular codon is observed, relative to the number of times
that the codon would be observed in the absence of any codon usage bias.

In the absence of any codon usage bias, the RSCU value would be 1.00.
A codon that is used less frequently than expected will have a value of less than 1.00 and vice versa for a codon that is used more frequently than expected.

Genetics Code: NCBI takes great care to ensure that the translation for each coding sequence (CDS) present in GenBank records is correct. Central to this effort is careful checking on the taxonomy of each record and assignment of the correct genetic code (shown as a /transl_table qualifier on the CDS in the flat files) for each organism and record. This page summarizes and references this work.
http://www.ncbi.nlm.nih.gov/Taxonomy/Utils/wprintgc.cgi

The following functions are provided by this module:

=over 3

=item new()

Constructor.

=item rscu_rac_table()

To Produce RSCU and RAC table along with codon and Amino acid name.

=item prefered_codon($myCodons)

Return you prefered codons list.

=item generate_graph($myCodons,"outputfile.gif")

Produce a bar graph between RAC(Relative Adaptiveness of a Codon) & RSCU (Relative Synonymous Codons Uses).

=item calculate_cai($myCodons)

Calculate Codon Adaptation Index (CAI) for sequence.

=item generate_report($outfile_name);

To Produce HTML report, this function will generate HTML report, outfile extension should be .html
example output : http://search.cpan.org/src/SHARDIWAL/Bio-Tools-CodonOptTable-1.05/result.html

=back

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/B*

%changelog
