# BEGIN SourceDeps(oneline):
BuildRequires: perl(Bio/DB/Fasta.pm) perl(Bio/Tools/GFF.pm) perl(Carp.pm) perl(Data/Dumper.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(Path/Class.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define module_version 0.06
%define module_name Bio-ViennaNGS-AnnoC
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.06
Release: alt1
Summary: Perl extension for converting sequence annotation formats
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/M/MT/MTW/%{module_name}-v%{module_version}.tar.gz
BuildArch: noarch

%description
=over 3

=item parse_gff($gff3_file)

`parse_gff()' parses GFF3 annotation files. The GFF3 specification is
available at http://www.sequenceontology.org/resources/gff3.html
This routine expects the path to a GFF3 file as argument `$gff3_file'
and returns two hash references: `$feat' is a reference to a HOH
containing the raw annotation information for each feature found in
the GFF3 file. `$fstat' references a hash containing summary statistics
of the features found in the GFF3 file.

This routine has been tested with NCBI bacteria GFF3 annotation. 

=item feature_summary($fstat,$dest)

This routine generates a summary file for all features parsed by
parse_gff. It expects two arguments: `$fstat' is a refence to the
summary hash generated by `parse_gff()' and `$dest' is the output
path for a summary.txt file.

=item get_fasta_ids($fasta_file)

`get_fasta_ids()' returns an array containing all headers/IDs of a
Fasta file as the Bio::DB:Fasta manpage objects. The Fasta file may contain
multiple entries.

=back
%prep
%setup -n %{module_name}-v%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/B*

%changelog
