%define module_name BioPerl
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Algorithm/Diff.pm) perl(AnyDBM_File.pm) perl(Bio/DB/Ace.pm) perl(Bio/DB/EMBL.pm) perl(Bio/DB/GenBank.pm) perl(Bio/DB/GenPept.pm) perl(Bio/Factory/EMBOSS.pm) perl(Bio/Tools/Run/Primer3.pm) perl(Bio/Tools/Run/StandAloneBlast.pm) perl(Carp.pm) perl(Class/Unload.pm) perl(Cwd.pm) perl(DB_File.pm) perl(Data/Dumper.pm) perl(Data/Stag.pm) perl(Digest/MD5.pm) perl(Dumpvalue.pm) perl(Error.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(Fcntl.pm) perl(File/Basename.pm) perl(File/Copy.pm) perl(File/Path.pm) perl(File/Spec.pm) perl(File/Spec/Functions.pm) perl(File/Temp.pm) perl(FileHandle.pm) perl(FindBin.pm) perl(Getopt/Long.pm) perl(Graph/Directed.pm) perl(HTTP/Request/Common.pm) perl(HTTP/Response.pm) perl(IO/File.pm) perl(IO/Handle.pm) perl(IO/Pipe.pm) perl(IO/Scalar.pm) perl(IO/Socket.pm)
BuildRequires: perl(IO/String.pm) perl(IPC/Open3.pm) perl(IPC/Run.pm) perl(LWP/UserAgent.pm) perl(List/MoreUtils.pm) perl(List/Util.pm) perl(Math/BigFloat.pm) perl(Module/Build.pm) perl(POSIX.pm) perl(Pod/Usage.pm) perl(SVG.pm) perl(Scalar/Util.pm) perl(Set/Scalar.pm) perl(Storable.pm) perl(Symbol.pm) perl(Test/Builder.pm) perl(Test/Builder/Module.pm) perl(Test/Memory/Cycle.pm) perl(Test/Mojibake.pm) perl(Test/More.pm) perl(Test/Most.pm) perl(Test/Pod.pm) perl(Test/RequiresInternet.pm) perl(Test/Weaken.pm) perl(Text/Balanced.pm) perl(Text/Wrap.pm) perl(Tie/Handle.pm) perl(Tie/RefHash.pm) perl(Time/HiRes.pm) perl(Tk.pm) perl(UNIVERSAL.pm) perl(URI.pm) perl(XML/DOM.pm) perl(XML/LibXML.pm) perl(XML/LibXML/Reader.pm) perl(XML/Parser/PerlSAX.pm) perl(XML/SAX.pm) perl(XML/SAX/Base.pm) perl(XML/SAX/Writer.pm) perl(XML/Twig.pm)
BuildRequires: perl(XML/Writer.pm) perl(YAML.pm) perl(base.pm) perl(constant.pm) perl(enum.pm) perl(integer.pm) perl(lib.pm) perl(overload.pm) perl(parent.pm) perl(strict.pm) perl(use.pm) perl(utf8.pm) perl(vars.pm) perl(version.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.7.8
Release: alt1
Summary: Perl modules for biology
Group: Development/Perl
License: perl
URL: https://metacpan.org/release/BioPerl

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/C/CJ/CJFIELDS/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
BioPerl is the product of a community effort to produce Perl code which is
useful in biology. Examples include Sequence objects, Alignment objects and
database searching objects. These objects not only do what they are advertised
to do in the documentation, but they also interact - Alignment objects are made
from the Sequence objects, Sequence objects have access to Annotation and
SeqFeature objects and databases, Blast objects can be converted to Alignment
objects, and so on. This means that the objects provide a coordinated and
extensible framework to do computational biology.

BioPerl development focuses on Perl classes, or code that is used to create
objects representing biological entities. There are scripts provided in the
scripts/ and examples/ directories but scripts are not the main focus of the
BioPerl developers. Of course, as the objects do most of the hard work for you,
all you have to do is combine a number of objects together sensibly to make
useful scripts.

The intent of the BioPerl development effort is to make reusable tools that aid
people in creating their own sites or job-specific applications.

The BioPerl website at http://bioperl.org also attempts to maintain links
and archives of standalone bio-related Perl tools that are not affiliated or
related to the core BioPerl effort. Check the site for useful code ideas and
contribute your own if possible.

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %name = %EVR

%description scripts
scripts for %module_name

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc AUTHORS Changes HACKING.md LICENSE README.md examples
%perl_vendor_privlib/B*

%files scripts
%_man1dir/*
%_bindir/*

%changelog
