%define module_name BioX-Seq
Epoch: 1
# BEGIN SourceDeps(oneline):
BuildRequires: perl(CPAN/Uploader.pm) perl(Compress/BGZF.pm) perl(Cwd.pm) perl(File/Basename.pm) perl(IO/Uncompress/Bunzip2.pm) perl(IO/Uncompress/Gunzip.pm) perl(IPC/Cmd.pm) perl(Module/Build.pm) perl(POSIX.pm) perl(Scalar/Util.pm) perl(Test/Exception.pm) perl(Test/More.pm) perl(parent.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.008009
Release: alt1
Summary: a (very) basic biological sequence object
Group: Development/Perl
License: gpl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/V/VO/VOLKENING/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
`BioX::Seq' is a simple sequence class that can be used to represent
biological sequences. It was designed as a compromise between using simple
strings and hashes to hold sequences and using the rather bloated objects of
Bioperl. Features (or, depending on your viewpoint, bugs) include
auto-stringification and context-dependent transformations. It is meant
be used primarily as the return object of the `BioX::Seq::Fastx' parser, but
there may be occasions where it is useful in its own right.

`BioX::Seq' current implements a small subset of the transformations most
commonly used by the author (reverse complement, translate, subrange) - more
methods may be added in the future as use suggests and time permits, but the
core object will be kept as simple as possible and should be limited to the
four current properties - sequence, ID, description, and quality - that
satisfy 99%% of the author's needs.

Some design decisions have been made for the sake of speed over ease of use.
For instance, there is no sanity-checking of the object properties upon
creation of a new object or use of the accessor methods. Parameters to the
constructor are positional rather than named (testing indicates that this
reduces execution times by ~ 40%%).
%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes LICENSE README.md
%perl_vendor_privlib/B*

%changelog
