%define module_name Bitcoin-Crypto
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Bitcoin/BIP39.pm) perl(Crypt/Perl/ECDSA/Parse.pm) perl(CryptX.pm) perl(Encode.pm) perl(ExtUtils/MakeMaker.pm) perl(Math/BigInt.pm) perl(Math/BigInt/GMP.pm) perl(Moo.pm) perl(Mooish/AttributeBuilder.pm) perl(Test/Exception.pm) perl(Test/More.pm) perl(Test/Pod.pm) perl(Try/Tiny.pm) perl(Type/Tiny.pm) perl(Unicode/Normalize.pm) perl(WordList/EN/BIP39.pm) perl(namespace/clean.pm) perl(parent.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 2.003
Release: alt1
Summary: Bitcoin cryptography in Perl
Group: Development/Perl
License: perl
URL: https://brtastic.xyz/project/bitcoin-crypto

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/B/BR/BRTASTIC/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This package allows you to do basic cryptography tasks for Bitcoin such as:

=over 2

=item * creating private key / public key pairs

=item * creating Bitcoin addresses (p2pkh)

=item * creating signatures for messages

=item * importing / exporting using popular mediums (WIF, mnemonic, hex)

=item * creating custom (non-Bitcoin) networks

=back

This package won't help you with:

=over 2

=item * generating random entropy for private keys

=item * serializing transactions

=item * using any Bitcoin CLI tools / clients

=item * connecting to Bitcoin network

=back

See child modules for more documentation and examples.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE Changes README.md
%perl_vendor_privlib/B*

%changelog
