# BEGIN SourceDeps(oneline):
BuildRequires: perl(Blatte.pm) perl(Blatte/Builtins.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(HTML/Entities.pm) perl(HTML/Tagset.pm) perl(Symbol.pm) perl(Test.pm)
# END SourceDeps(oneline)
%define module_version 0.9
%define module_name Blatte-HTML
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.9
Release: alt1
Summary: tools for generating HTML with Blatte
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/B/BO/BOBG/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
This module defines Blatte functions corresponding to HTML tags,.making it possible to write Blatte that looks like this:

  Here is a {\a \href=http://www.blatte.org/ link}

and can be translated to this:

  Here is a <a href="http://www.blatte.org/">link</a>

The beauty is that you can use Blatte functions to encapsulate
repeated constructs.  For instance, this definition:

  {\define {\mypagestyle \=name \&content}
   {\html {\head {\title \name}}
          {\body {\h1 \name} \content}}}

allows you to write

  {\mypagestyle \name={A page I wrote} This is my page.}

which saves you from having to write:

  <html><head><title>A page I wrote</title></head>
  <body><h1>A page I wrote</h1>This is my page.</body></html>

End-tags are supplied automatically.  The module HTML::Tagset, by
Gisle Aas and Sean M. Burke, is used to identify HTML elements that
require no end-tag.

Paragraph tags (<p>) are also supplied automatically wherever a blank
line appears in the text.  For instance, this:

  Here is some text.

  Here is some more.

becomes this:

  Here is some text.

  <p>Here is some more.

This module tries hard to keep HTML element nesting correct.  For
instance, this:

  Paragraph 1.

  Paragraph 2 {\b with some bold text

  continuing to paragraph 3}.

becomes this:

  Paragraph 1.

  <p>Paragraph 2 <b>with some bold text</b></p>

  <p><b>continuing to paragraph 3</b>.

Entity-encoding is automatic too.  So this:

  Five & dime

becomes this:

  Five &amp; dime

It's possible to suppress automatic <p>-tag generation and entity-encoding by
writing:

  {\html_p_no ...content...}

and

  {\html_ent_no ...content...}

Inside an {\html_p_no ...} it's possible to reenable <p>-tag generation with
{\html_p_yes ...}, and inside {\html_ent_no ...} it's possible to reenable
entity encoding with {\html_ent_yes ...}.

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %{?epoch:%epoch:}%name = %version-%release

%description scripts
scripts for %module_name


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build INSTALLMAN1DIR=%_man1dir

%install
%perl_vendor_install

%files
%doc ChangeLog LICENSE README TODO
%perl_vendor_privlib/B*

%files scripts
%_bindir/*
%_man1dir/*

%changelog
