%define module_name Blockchain-Ethereum-RLP
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(IO/Handle.pm) perl(IPC/Open3.pm) perl(Test/CPAN/Meta.pm) perl(Test/CheckDeps.pm) perl(Test/DistManifest.pm) perl(Test/Mojibake.pm) perl(Test/More.pm) perl(Test/Perl/Critic.pm) perl(Test/Pod.pm) perl(Test/Portability/Files.pm) perl(Test/Version.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.011
Release: alt1
Summary: Ethereum RLP encoding/decoding utility
Group: Development/Perl
License: mit
URL: https://github.com/refeco/Blockchain-Ethereum-RLP

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/R/RE/REFECO/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Allow RLP encoding and decoding

This class is basically an transpilation of the RLP encode/decode python sample given at https://ethereum.org/en/developers/docs/data-structures-and-encoding/rlp/

    my $rlp = Blockchain::Ethereum::RLP->new();

    my $tx_params  = ['0x9', '0x4a817c800', '0x5208', '0x3535353535353535353535353535353535353535', '0xde0b6b3a7640000', '0x', '0x1', '0x', '0x'];
    my $encoded = $rlp->encode($params); #ec098504a817c800825208943535353535353535353535353535353535353535880de0b6b3a764000080018080

    my $encoded_tx_params = 'ec098504a817c800825208943535353535353535353535353535353535353535880de0b6b3a764000080018080';
    my $decoded = $rlp->decode(pack "H*", $encoded_tx_params); #['0x9', '0x4a817c800', '0x5208', '0x3535353535353535353535353535353535353535', '0xde0b6b3a7640000', '0x', '0x1', '0x', '0x']
    ...

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes LICENSE
%perl_vendor_privlib/B*

%changelog
