# BEGIN SourceDeps(oneline):
BuildRequires: perl(CPAN.pm) perl(Carp.pm) perl(Config.pm) perl(Cwd.pm) perl(ExtUtils/MM_Unix.pm) perl(ExtUtils/MakeMaker.pm) perl(ExtUtils/Manifest.pm) perl(File/Basename.pm) perl(File/Find.pm) perl(File/Spec.pm) perl(FileHandle.pm) perl(Filter/Simple.pm) perl(LWP/Simple.pm) perl(Module/Build.pm) perl(Net/FTP.pm) perl(Socket.pm) perl(Test/More.pm) perl(YAML.pm) perl(inc/Module/Install.pm)
# END SourceDeps(oneline)
%define module_version 0.001
%define module_name Blosxom-Debug
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.001
Release: alt1
Summary: a blosxom helper module and source filter to provide a 
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/G/GA/GAVINC/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
Blosxom::Debug is a perl module to provide simple standardised debug logging 
facilities to blosxom plugins. It exports a debug() function of the form:

    debug($level, $message);

which logs $message to your webserver log if $level is greater than or equal
to the debug_level specified in your 'use' statement.

So the following statement:

    debug(1, 'This is a level 1 message, visible only if debug_level >= 1');

will show up in your webserver log if you do a:

    use Blosxom::Debug debug_level => 1;

but not if you do:

    use Blosxom::Debug debug_level => 0;

In the latter case, however, all your debug statements are still all
executed, it is just that the output is suppressed because the debug_level
is too low. There is therefore a small runtime overhead incurred, which you
would probably prefer to avoid unless you're debugging.

For this reason, Blosxom::Debug is also a perl source filter which actively
uncomments debug statements if enabled. This allows you to distribute plugins
including:

    # use Blosxom::Debug debug_level => 1

    # and then later on in your plugin ...
    # debug(1, "This is a level 1 message");

with both the use statement and all your debug statements commented out, and
therefore incurring no runtime overhead in production.

When you run into a problem you need to debug, you then simply uncomment
just the 'use' statement, which activates all (single-hash) commented debug
statements at runtime i.e.

    use Blosxom::Debug debug_level => 1

    # and this debug statement will now be invoked, even though commented
    # debug(1, "This is a level 1 message");

Note that your debug statements therefore must be valid perl, since they
actually are executed as normal.

To actually hide debug statements from Blosxom::Debug, you must comment them
out with more than one hash e.g.

    ## debug(1, "This message is hidden, no matter what the debug_level");



%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%perl_vendor_privlib/B*

%changelog
