%define module_name Bot-BasicBot-Pluggable-Module-Crontab
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Bot/BasicBot/Pluggable.pm) perl(DateTime.pm) perl(File/Temp.pm) perl(FindBin/libs.pm) perl(IO/File.pm) perl(Test/MockModule.pm) perl(Test/More.pm) perl(Time/Crontab.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.01
Release: alt1
Summary: Provides a crontab-like message service for IRC channels
Group: Development/Perl
License: artistic_2
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/B/BA/BARBIE/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module does not respond to user messages, public or private. It is purely
for posting messages to notminated channels as a specifed time.

A crontab like file is used to load instruction sets, which are then acted on
at the designated time.

Examples are:

    +-- minute
    | +-- hour
    | | +-- day of the month
    | | | +-- month (1= January, ...)
    | | | | +-- day of the week (0 = sunday ....)
    | | | | | +-- week of the year (2/0 = even weeks, 2/1 = odd weeks)
    v v v v v v
    * * * * * * #dev Minute Check!
    0 * * * * * #dev Hour Check!
    */10 * * * * * #dev 10 minute Check!
    0 9 * * 1 2/0 #dev Review every even week
    0 9 * * 1 3/1 #dev Review every third Week

As per normal crontabs, the first 5 fields allow for ranges, steps as well as strict values.
The 6th field is the week of the year field. In working with Scrum teams running 2 week sprints,
knowing when it was an odd week or even week, meant we knew whether we had a regular stand-up
or sprint planning meeting.

By default this field can be attributed to every week using the traditional '*' symbol. However,
to determine when to run, a two part value is used, separated by a '/' symbol. The first part
designates the modulus value, and the second part the result it must match. For example, to
trigger fornightly on week 1, 3, 5, etc, this would be '2/1'. To trigger every second week of a
3 week sprint, this would be '3/1'.

The 7th field determines the channel to post to. Note that the bot cannot post to all channels.
However, may be a feature added in a future release.

The final free form field is the message. The complete line will be sent, with any line
continuation markers ignored. Line continuation markers may be a feature in the future.
%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes LICENSE README examples
%perl_vendor_privlib/B*

%changelog
