# BEGIN SourceDeps(oneline):
BuildRequires: perl(Bot/ChatBots.pm) perl(Data/Tubes.pm) perl(Log/Any.pm) perl(Minion.pm) perl(Minion/Backend/SQLite.pm) perl(Mock/Quick.pm) perl(Module/Build/Tiny.pm) perl(Mojolicious.pm) perl(Ouch.pm) perl(Path/Tiny.pm) perl(Test/Exception.pm) perl(Test/More.pm) perl(Test/Pod.pm) perl(Test/Trap.pm)
# END SourceDeps(oneline)
%define module_name Bot-ChatBots-Minion
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.004
Release: alt1
Summary: Minion plugin for Chat::ChatBots
Group: Development/Perl
License: artistic_2
URL: https://github.com/polettix/Bot-ChatBots-Minion

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/P/PO/POLETTIX/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
(Note: you are supposed to be familiar with the Data::Tubes manpage terminology).

This module allows you to break a potentially blocking long pipeline of
operations into two parts, shifting the second part for execution in
a Mojolicious Minion.

For example, suppose you are using both the Data::Tubes manpage and
the Bot::ChatBots::Telegram::WebHook manpage in a the Mojolicious::Lite manpage app like
this:

   use Mojolicious::Lite;
   use Data::Tubes qw< pipeline >;

   my $pipeline = pipeline(
      \&simple_operation_1,
      \&simple_operation_2,
      \&long_running_operation,
      \&simple_operation_3,
      {tap => sink},
   );

   plugin Bot::ChatBots::Telegram => sources => [
      'Bot::ChatBots::Telegram::WebHook',
      processor => $pipeline,
      ...
   ];

   app->start;

When a new update comes, it will eventually hit `long_running_operation'
and block your frontend process. Ouch! This is what you can do instead:

   use Mojolicious::Lite;
   use Data::Tubes qw< pipeline >;

   # configure Minion before calling Bot::ChatBots::Minion
   plugin Minion => ...;
   plugin 'Bot::ChatBots::Minion';

   my $pipeline = pipeline(
      \&simple_operation_1,
      \&simple_operation_2,
      app->chatbots->minion->wrapper(
         downstream => pipeline(
            \&long_running_operation,
            \&simple_operation_3,
            {tap => sink},
         )
      ),
      {tap => sink},
   );

   # the rest is as before
   plugin Bot::ChatBots::Telegram => sources => [
      'Bot::ChatBots::Telegram::WebHook',
      processor => $pipeline,
      ...
   ];

   app->start;

So the trick is to divide the long-running pipeline into two separate
pipelines, one to be executed in the main process with the first two
simple operations and ending with a wrapper for the second pipeline, which
includes the long operation. The wrapping mechanism takes care to send the
received record along to the Minion worker, where the second pipeline will
be executed.

You don't actually have to call `pipeline' inside ...

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes LICENSE
%perl_vendor_privlib/B*

%changelog
