# BEGIN SourceDeps(oneline):
BuildRequires: perl(Bot/BasicBot.pm) perl(ExtUtils/MakeMaker.pm) perl(HTTP/Request/Common.pm) perl(LWP/UserAgent.pm) perl(Log/Log4perl.pm) perl(POE.pm) perl(Pod/Usage.pm) perl(Test/More.pm) perl(base.pm) perl(POE/Component/Client/HTTP.pm)
# END SourceDeps(oneline)
%define module_version 0.09
%define module_name Bot-WootOff
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.09
Release: alt1
Summary: Poll woot.com during a woot-off and notify via IRC
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/M/MS/MSCHILLI/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
Bot::WootOff periodically polls woot.com during a woot-off and sends .messages to in IRC channel to alert the user of new items.

What, you don't know what woot.com is? It's a site that sells one item
a day at a discounted price. Once the item is sold out, the site runs idle
for the rest of the day. But every once in a while, it switches into
a mode called woot-off, where it keeps popping up new items as soon as
the lot of the previous item is sold. This is called a "Woot Off",
and it's something many people are looking forward to, as all items,
and most of all, the legendary "Bag of Crap", can be had a bargain price.
If you think all of this is silly, move on to the next CPAN module! Nice
meeting you! If you're a bargain hunter, continue reading.

If you notice that there's a woot-off going on on woot.com, simply start
your bot via the 'wootbot' script included in this module, like

    wootbot -s irc.freenote.net -c '#wootoff'

or use the perl code in the SYNOPSIS section of this document. The
bot will start up, connect to the IRC server, and log into the channel
specified. It'll start polling woot.com in 30-second intervals until the 
next item in the woot-off will be presented. At this point, it will post
a short item description to the IRC channel to alert the user of the
buying opportunity:

    Trying to connect to server irc.freenode.net
    Trying to connect to '#wootoff0538'
    2009/05/13 23:17:36 Requesting http://www.woot.com
    2009/05/13 23:17:36 Apple 8GB 4th Gen iPod Nano posted to #wootoff0538

The above output can be seen if you start `wootbot' in verbose mode, using
the `-v' option. It also prints status messages like

    2009/05/13 23:36:23 Requesting http://www.woot.com
    2009/05/13 23:36:24 Nothing changed
    2009/05/13 23:36:54 Requesting http://www.woot.com
    2009/05/13 23:36:54 Nothing changed

to STDOUT in regular intervals to let the user know what it's doing. When
it posts messages to the IRC channel specified, it will use the nickname
"wootbot" (unless you specify another nickname in the constructor). The 
messages will look like 

    (11:41:29 PM) wootbot: Forever Flashlight  III 4.99 http://www.woot.com
    (11:44:32 PM) wootbot: Deluxe Charades Game 2.99 http://www.woot.com

Each message contains a link to woot.com, which will be displayed by IRC
clients like Pidgin in a clickable format, so that you can reach the 
current offer with a single mouse click.

If someone in the channel says "!woot" then the bot will repeat its last
message. This is helpful if someone just joined the channel and wants
to know what the current item is.

All you have to do to receive these message is use an IRC client like 
Pidgin, connect to the IRC server specified (irc.freenode.net by default),
log into the channel specified (#wootoffxxxx by default, where xxxx is 
a random number so that all of you script kiddies using this module won't
step on other people's toes. Use a specific name like #wootoff to connect to
the actual channel specified), and enjoy the incoming messages. Set up
sounds and you'll be able to do useful work while being interrupted with
the latest bargains.

Extra tip: If your IRC window in Pidgin gets full and you want the visual 
interruption of an empty window being filled, use CTRL-L to clear the
current window.

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %{?epoch:%epoch:}%name = %version-%release

%description scripts
scripts for %module_name


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build INSTALLMAN1DIR=%_man1dir

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/B*

%files scripts
%_bindir/*
%_man1dir/*

%changelog
