# BEGIN SourceDeps(oneline):
BuildRequires: perl(CGI/FormBuilder.pm) perl(Carp.pm) perl(ExtUtils/MakeMaker.pm) perl(Module/Build.pm) perl(Test/HTML/Lint.pm) perl(Test/HTML/Tidy.pm) perl(Test/More.pm) perl(Test/Perl/Critic.pm) perl(WWW/Mechanize.pm) perl(base.pm) perl(version.pm)
# END SourceDeps(oneline)
%define module_version 0.09
%define module_name Business-CCProcessor
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.09
Release: alt1
Summary: Pass transaction off to secure processor
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/H/HE/HESCO/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
At present this module and its methods are trivially simple
in what they do, offering as its one service, the ability to
hide how to munge your web form's data into a post call to a
supported credit card processor.

Business::CCProcessor will permit a script to collect
non-financial data locally and then using an http POST call,
hand that data off to a secure credit card processor which
then collects the credit card parameters, and processes
the transaction between the credit card owners account and
the script owners account. This is a poor man's variant on
Business::OnlinePayment for clients who cannot afford the video
camera watched locked cages around their dedicated server,
to collect credit card payments from their buyers or donors,
in a real-time interaction with the credit card owner.

This module is for you if you need to accept online credit card
payments for your organization or services but are not prepared
to invest in an ssl certificate, a dedicated IP address, a
dedicated server and the monitored restricted access to your
server which the privacy of your customers or donors requires.

Initially this module offers five public methods: a constructor,
a button_factory and methods for munging data for three (so
far) credit card processors, but additional methods to handle
additional credit card processors who permit this sort of
interaction should be straight forward to add.

Each of the credit card processor methods takes a reference to
a hash of values which you will have to create before calling
the method.  This data is generally of the form:

    my %%data = (
      'processor_settings' => \%%processor_settings,
      'credit_card_owner' => \%%credit_card_owner,
      );

The second part of the hash is fairly consistent across the methods,
with some methods offering additional options for passing data than
others, but generally, this hash looks like this:

    %%credit_card_owner = (
              'fname' => '',
              'lname' => '',
              'addr1' => '',
              'addr2' => '',
               'city' => '',
              'state' => '',
        'postal_code' => '',
           'comments' => '',
          'comments1' => '',
              'phone' => '',
              'email' => '',
           'employer' => '',
         'occupation' => '',
             'amount' => '',
              'notes' => '',
       'button_label' => '',
        );

The %%processor_settings hash's structure is dependent on which
credit card processor method you are using.

As this module develops, I anticipate also providing for a
mode, to permit this module to be switched from 'commercial',
to 'non-profit', to 'electoral_campaign' mode, to account
for variances in how what data is collected for each of these
types of users.


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/B*

%changelog
