# BEGIN SourceDeps(oneline):
BuildRequires: perl(Business/OnlinePayment.pm) perl(Business/OnlinePayment/HTTPS.pm) perl(ExtUtils/MakeMaker.pm) perl(Test.pm) perl(Test/More.pm) perl(URI/Escape.pm)
# END SourceDeps(oneline)
%define module_version 0.02
%define module_name Business-OnlinePayment-Beanstream
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.02
Release: alt1
Summary: Beanstream backend for Business::OnlinePayment
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/I/IL/ILYALIT/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
This module allows you to link any e-commerce order processing system directly to Beanstream transaction server (http://www.beanstream.com). All transaction fields are submitted via GET or POST to the secure transaction server at the following URL: https://www.beanstream.com/scripts/process_transaction.asp. The following fields are required:.
=over 4

=item login - merchant login (Beanstream-assigned nine digit identification number)

=item action - type of transaction (Normal Authorization, Authorization Only)

=item amount - total order amount

=item invoice_number - the order number of the shopper's purchase

=item owner - name of the card owner

=item card_number - number of the credit card

=item expiration - expiration date formated as 'mmyy' or 'mm/yy'

=item name - name of the billing person

=item address - billing address

=item city - billing address city

=item state - billing address state/province

=item zip - billing address ZIP/postal code

=item country - billing address country

=item phone - billing contacts phone

=item email - billing contact's email

=back

Beanstream supports the following credit card:

=over 4

=item - VISA

=item - MasterCard

=item - American Express Card

=item - Discover Card

=item - JCB

=item - Diners

=back

Currently you may process only two types of transaction, namely 'Normal Authorization' (Purchase) and 'Authorization Only' (Pre-Auth).

For detailed information about methods see the Business::OnlinePayment manpage


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/B*
%perl_vendor_privlib/auto/*
%changelog
