%filter_from_requires /^perl.SiteCatalystConfig.pm./d
%define module_version 1.2.2
%define module_name Business-SiteCatalyst
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(Data/Dumper.pm) perl(Data/Validate/Type.pm) perl(DateTime.pm) perl(Digest/MD5.pm) perl(Digest/SHA1.pm) perl(English.pm) perl(ExtUtils/MakeMaker.pm) perl(HTTP/Request.pm) perl(JSON.pm) perl(LWP/UserAgent.pm) perl(MIME/Base64.pm) perl(Module/Build.pm) perl(Test/Exception.pm) perl(Test/More.pm) perl(Test/Perl/Critic.pm) perl(Try/Tiny.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.2.2
Release: alt2
Summary: Interface to Adobe Omniture SiteCatalyst's REST API.
Group: Development/Perl
License: artistic
URL: https://metacpan.org/release/Business-SiteCatalyst

Source0: http://cpan.org.ua/authors/id/J/JP/JPINKHAM/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
This module allows you to interact with Adobe (formerly Omniture) SiteCatalyst,
a web analytics service. It encapsulates all the communications with the API 
provided by Adobe SiteCatalyst to offer a Perl interface for managing reports,
pulling company-specific SiteCatalyst data (ex: token usage), uploading SAINT 
data (feature not implemented yet), etc.

Please note that you will need to have purchased the Adobe SiteCatalyst product,
and have web services enabled within your account first in order to obtain a web
services shared secret, as well as agree with the Terms and Conditions for using 
the API.

NOTE: the 'api_subdomain' option/config variable is utilized for the api url.
To determine your specific API URL/Endpoint, please visit
https://developer.omniture.com/en_US/get-started/api-explorer
Most users won't need to set this variable unless the default causes errors.

API URL: 'https://' . $api_subdomain . '.omniture.com/admin/1.3/rest/?'


	use Business::SiteCatalyst;
	
	# Create an object to communicate with Adobe SiteCatalyst
	my $site_catalyst = Business::SiteCatalyst->new(
		username        => 'dummyusername',
		shared_secret   => 'dummysecret',
		api_subdomain   => 'api|api2', #optional; default value='api'
	);



%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/B*

%changelog
