# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(Test/Simple.pm)
# END SourceDeps(oneline)
%define module_name Business-Tax-US-Form_1040-Worksheets
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.06
Release: alt1
Summary: IRS Form 1040 worksheets calculations
Group: Development/Perl
License: Perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/J/JK/JKEENAN/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This library exports, on demand only, functions which implement calculations
used in various worksheets found in U.S. IRS Form 1040 instructions.

Acronyms:

=over 4

=item *

SSBW: *Social Security Benefits Worksheet*, *e.g.,* as found on page 32
of IRS Form 1040 Instructions for filing year 2023.

=item *

QDCGTW: *Qualified Dividends and Capital Gain Tax Worksheet*, *e.g.,* as
found on page 37 of those 2023 Instructions.

=back

The current version of this library supports the SSBW and most of the QDCGTW
for filing years 2022 and 2023.  Future versions may extend the support of
those worksheets forwards and backwords; may offer more complete support for
the QDCGTW; and may offer support for other worksheets found within the Form
1040 instructions.

The accuracy of the calculations in these functions has not been reviewed by
the Internal Revenue Service, any other tax authority, any accountant or any
attorney.  Use at your own risk!

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes LICENSE
%perl_vendor_privlib/B*

%changelog
