# BEGIN SourceDeps(oneline):
BuildRequires: perl(CGI.pm) perl(CGI/Application.pm) perl(ExtUtils/MakeMaker.pm) perl(HTML/Template.pm) perl(Test.pm)
# END SourceDeps(oneline)
%define module_version 1.0
%define module_name CGI-Application-Generator
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.0
Release: alt1
Summary: Dynamically build CGI::Application modules
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/J/JE/JERLBAUM/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
CGI::Application::Generator provides a means by which a CGI::Application 
module can be created from code, as opposed to being written by hand.  The 
goal of this module is two-fold:

  1. To ease the creation of new CGI::Application modules.
  2. To allow standardization of CGI::Application coding
     styles to be more uniformly applied.


It is also the hope of this module that Computer Assisted 
Software Engineering (CASE) tools will eventually emerge 
which will allow the development process for web-based applications
to be greatly improved.  These CASE tools could more easily 
convert visual notation (such as UML state-transition diagrams)
into method calls to this module, thereby creating actual code.


What This Module Does Not Do

CGI::Application::Generator is intended to create a shell of 
an application module based on the specification you provide.
It will not output a completely functional application without
additional coding.  It will, however, handle the creation of all 
the structural parts of your application common to all
CGI::Application-based modules.

CGI::Application::Generator is not a system for HTML templates.
If you're looking for a Perl module which will allow you
to separate Perl from HTML then I recommend you download and install
HTML::Template.



%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/C*

%changelog
