# BEGIN SourceDeps(oneline):
BuildRequires: perl(CGI/Application.pm) perl(Exporter.pm) perl(Module/Build.pm) perl(Test/More.pm) perl(base.pm) perl(HTML/Template.pm)
# END SourceDeps(oneline)
%define module_version 1.01
%define module_name CGI-Application-Plugin-PageBuilder
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.01
Release: alt1
Summary: Simplifies building pages with multiple templates.
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/S/ST/STEVEB/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
This module simplifies building complex web pages with many small piecemeal templates.

Instead of

 sub run_mode {
     my $self = shift;
     my $header = $self->load_tmpl( 'header.tmpl' )->output();
     my $html;

     my $start = $self->load_tmpl( 'view_start.tmpl' );
     $start->param( view_name => 'This View' );
     $html .= $start->output();

     my $db = MyApp::DB::Views->retrieve_all(); # Class::DBI
     while ( my $line = $db->next() ) {
         my $template = $self->load_tmpl( 'view_element.tmpl' );
         $template->param( name => $line->name() );
         $template->param( info => $line->info() );
         $html .= $template->output();
     }
     $html .= $self->load_tmpl( 'view_end.tmpl' )->output();
     $html .= $self->load_tmpl( 'footer.tmpl' )->output();
     return $html;
 }

You can do this:

 CGI:App subclass:

 sub run_mode {
     my $self = shift;

     $self->pb_template( 'header.tmpl' );
     $self->pb_template( 'view_start.tmpl' );

     my $db = MyApp::DB::Views->retrieve_all();
     while( my $line = $db->next() ) {
         $self->pb_template( 'view_row.tmpl' );
         $self->pb_param( name, $line->name() );
         $self->pb_param( info, $line->info() );
     }
     $self->pb_template( 'view_end.tmpl' );
     $self->pb_template( 'footer.tmpl' );
     return $self->pb_build();
 }
%prep
%setup -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/C*

%changelog
