# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(CGI.pm) perl(CGI/Simple.pm) perl(Digest/MD5.pm) perl(ExtUtils/MakeMaker.pm) perl(HTML/Template.pm) perl(Test/More.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    CGI-Auth
%define upstream_version 3.00

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt3_14

Summary:	Simple session-based password authentication for CGI applications
License:	BSD-like
Group:		Development/Perl
Url:		https://metacpan.org/release/%{upstream_name}
Source0:	https://cpan.metacpan.org/authors/id/C/CC/CCWALLACE/%{upstream_name}-%{upstream_version}.tar.bz2

BuildArch:	noarch
Source44: import.info

%description
"CGI::Auth" provides password authentication for web-based applications. It
uses server-based session files which are referred to by a parameter in all
links and forms inside the scripts guarded by "CGI::Auth".

At the beginning of each script, a "CGI::Auth" object should be created and its
"check" method called. When this happens, "check" checks for a 'session_file'
CGI parameter. If that parameter exists and has a matching session file in the
session directory, "check" returns, and the rest of the script can execute.

If the session file parameter or the file itself doesn't exist, "check"
presents the user with a login form and exits the script. The login form will
then be submitted to the same script (specified in "-formaction"). When "check"
is called this time, it verifies the user's login information in the userfile,
creates a session file and provides the session file parameter to the rest of
the script.

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor
%make_build

#%%check
#make test

%install
%makeinstall_std

%files
%doc Changes README extra
%{perl_vendor_privlib}/CGI/*




%changelog
