%define module_name CGI-Buffer
# BEGIN SourceDeps(oneline):
BuildRequires: perl(CGI/Info.pm) perl(CHI.pm) perl(CSS/Packer.pm) perl(Carp.pm) perl(Compress/Zlib.pm) perl(Compress/Zstd.pm) perl(DateTime.pm) perl(DateTime/Format/HTTP.pm) perl(Digest/MD5.pm) perl(Encode.pm) perl(Encode/CN.pm) perl(Encode/JP.pm) perl(Encode/KR.pm) perl(Encode/TW.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(HTML/Clean.pm) perl(HTML/Lint.pm) perl(HTML/Packer.pm) perl(HTTP/Date.pm) perl(HTTP/Status.pm) perl(IO/Compress/Brotli.pm) perl(IO/String.pm) perl(JavaScript/Packer.pm) perl(LWP/ConnCache.pm) perl(LWP/UserAgent.pm) perl(Readonly.pm) perl(Storable.pm) perl(Test/DescribeMe.pm) perl(Test/Most.pm) perl(Test/Needs.pm) perl(Test/TempDir/Tiny.pm) perl(Text/Diff.pm) perl(Time/localtime.pm) perl(autodie.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.88
Release: alt1
Summary: Verify and Optimise CGI Output
Group: Development/Perl
License: open_source
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/N/NH/NHORNE/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
CGI::Buffer verifies the HTML that you produce by passing it through
`HTML::Lint'.

CGI::Buffer optimises CGI programs by compressing output to speed up
the transmission and by nearly seamlessly making use of client and
server caches.

To make use of client caches, that is to say to reduce needless calls
to your server asking for the same data, all you need to do is to
include the package, and it does the rest.

    use CGI::Buffer;
    # ...

To also make use of server caches, that is to say to save regenerating
output when different clients ask you for the same data, you will need
to create a cache.
But that's simple:

    use CHI;
    use CGI::Buffer;

    # Put this at the top before you output anything
    CGI::Buffer::init(
_cache => CHI->new(driver => 'File')
    );
    if(CGI::Buffer::is_cached()) {
_# Nothing has changed - use the version in the cache
_exit;
    }

    # ...

If you get errors about Wide characters in print it means that you've
forgotten to emit pure HTML on non-ascii characters.
See the HTML::Entities manpage.
As a hack work around you could also remove accents and the like by using
the Text::Unidecode manpage,
which works well but isn't really what you want.
%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README ignore.txt Changes LICENSE README.md
%perl_vendor_privlib/C*

%changelog
