# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    CGI-Cookie-Splitter
%define upstream_version 0.05

%{?perl_default_filter}

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt1_6

Summary:    Split big cookies into smaller ones
License:    GPL+ or Artistic
Group:      Development/Perl
Url:        https://metacpan.org/release/%{upstream_name}
Source0:    https://cpan.metacpan.org/modules/by-module/CGI/%{upstream_name}-%{upstream_version}.tar.gz
# Fix the tests due to https://rt.cpan.org/Ticket/Display.html?id=81612

BuildRequires: perl(CGI/Simple/Util.pm)
BuildRequires: perl(Carp.pm)
BuildRequires: perl(ExtUtils/MakeMaker.pm)
BuildRequires: perl(File/Spec/Functions.pm)
BuildRequires: perl(List/Util.pm)
BuildRequires: perl(Module/Build/Tiny.pm)
BuildRequires: perl(Scalar/Util.pm)
BuildRequires: perl(Test/More.pm)
BuildRequires: perl(namespace/clean.pm)
BuildRequires: perl(ok.pm)
BuildRequires: perl(strict.pm)
BuildRequires: perl(version.pm)
BuildRequires: perl(warnings.pm)
BuildArch:  noarch
Source44: import.info

%description
RFC 2109 reccommends that the minimal cookie size supported by the client is
4096 bytes. This has become a pretty standard value, and if your server
sends larger cookies than that it's considered a no-no.

This module provides a pretty simple interface to generate small cookies
that are under a certain limit, without wasting too much effort.

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor

%make_build

%check
%make_build test

%install
%makeinstall_std

%files
%doc CONTRIBUTING Changes INSTALL LICENSE META.json META.yml  README
%{perl_vendor_privlib}/*


%changelog
