# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(APR/Pool.pm) perl(Apache2/RequestIO.pm) perl(Apache2/RequestRec.pm) perl(Apache2/RequestUtil.pm) perl(Apache2/Response.pm) perl(ExtUtils/MakeMaker.pm) perl(IO/File.pm) perl(ModPerl/Util.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    CGI-GuruMeditation
%define upstream_version 1.10

Name:		perl-%{upstream_name}
Version:	%{upstream_version}
Release:	alt2_10

Summary:	Guru Meditation for CGIs
License:	GPL+ or Artistic
Group:		Development/Perl
URL:		https://metacpan.org/release/%{upstream_name}
Source0:	https://cpan.metacpan.org/authors/id/R/RS/RSE/%{upstream_name}-%{upstream_version}.tar.bz2

BuildArch:	noarch
Source44: import.info

%description
This is a small module accompanying the CGI module, providing the display of an
error screen (somewhat resembling the classical red-on-black blinking Guru
Meditation from the good-old AmigaOS before version 2.04) in case of abnormal
termination of a CGI.

The module simply installs a $SIG{__DIE__} handler which sends a HTTP response
showing a HTML/CSS based screen which optionally includes the Perl run-time
error message, an excerpt from the CGI source code and the Perl run-time
environment variables. This provides both optically more pleasant and
functionally more elaborate error messages for CGIs.

This module supports both the regular CGI and the Apache/mod_perl CGI
environment.

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor
%make_build

%install
%makeinstall_std

%files
%doc README
%{perl_vendor_privlib}/CGI/*




%changelog
