%define module_name CGI-Lingua
# BEGIN SourceDeps(oneline):
BuildRequires: perl(CGI/Info.pm) perl(CHI.pm) perl(Class/Autouse.pm) perl(Class/Load.pm) perl(DBD/SQLite.pm) perl(Data/Validate/IP.pm) perl(ExtUtils/MakeMaker.pm) perl(Geo/IP.pm) perl(Geo/IPfree.pm) perl(HTTP/BrowserDetect.pm) perl(I18N/AcceptLanguage.pm) perl(I18N/LangTags/Detect.pm) perl(IP/Country.pm) perl(IPC/System/Simple.pm) perl(LWP/Simple.pm) perl(Locale/Codes.pm) perl(Locale/Language.pm) perl(Locale/Object.pm) perl(Locale/Object/Country.pm) perl(Net/Subnet.pm) perl(Net/Whois/IANA.pm) perl(Net/Whois/IP.pm) perl(NetAddr/IP.pm) perl(Sys/Syslog.pm) perl(Test/Compile.pm) perl(Test/Distribution.pm) perl(Test/Kwalitee.pm) perl(Test/Most.pm) perl(Test/NoWarnings.pm) perl(Test/Perl/Metrics/Simple.pm) perl(Test/Requires.pm) perl(Test/Without/Module.pm) perl(WWW/RT/CPAN.pm) perl(autodie.pm) perl(warnings/unused.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.62
Release: alt1
Summary: Create a multilingual web page
Group: Development/Perl
License: open_source
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/N/NH/NHORNE/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
No longer does your website need to be in English only.
CGI::Lingua provides a simple basis to determine which language to display a
website. The website tells CGI::Lingua which languages it supports. Based on
that list CGI::Lingua tells the application which language the user would like
to use.

    use CGI::Lingua;
    # ...
    my $l = CGI::Lingua->new(supported => ['en', 'fr', 'en-gb', 'en-us']);
    my $language = $l->language();
    if ($language eq 'English') {
       print '<P>Hello</P>';
    } elsif($language eq 'French') {
_print '<P>Bonjour</P>';
    } else {_# $language eq 'Unknown'
_my $rl = $l->requested_language();
_print "<P>Sorry for now this page is not available in $rl.</P>";
    }
    my $c = $l->country();
    if ($c eq 'us') {
      # print contact details in the US
    } elsif ($c eq 'ca') {
      # print contact details in Canada
    } else {
      # print worldwide contact details
    }

    # ...

    use CHI;
    use CGI::Lingua;
    # ...
    my $cache = CHI->new(driver => 'File', root_dir => '/tmp/cache', namespace => 'CGI::Lingua-countries');
    my $l = CGI::Lingua->new({ supported => ['en', 'fr'], cache => $cache });


%prep
%setup -q -n %{module_name}-%{version}

%build
export AUTOMATED_TESTING=1
export AUTOMATED_TESTING=1
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes LICENSE ignore.txt README README.md
%perl_vendor_privlib/C*

%changelog
