%define module_name CGI-OptimalQuery
# BEGIN SourceDeps(oneline):
BuildRequires: perl(CGI.pm) perl(DBD/SQLite.pm) perl(DBI.pm) perl(Exporter.pm) perl(FindBin.pm) perl(JSON/XS.pm) perl(Mail/Sendmail.pm) perl(base.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.30
Release: alt1
Summary: rich HTML viewer for your SQL select queries
Group: Development/Perl
License: see LICENSE
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/L/LI/LIKEHIKE/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Developer describes environment, output options, and database query; CGI::OptimalQuery provides user with a web interface to view, filter, sort, and export the data.

Sounds simple, but CGI::OptimalQuery does not write the SQL for the developer. It is only responsible for gluing the appropriate pieces of SQL together to form an optimized SQL query, and outputing the results in a format the user chooses.

This module has been tested for SQLite, mysql, postgres, Microsoft SQL Server, and Oracle.

The important elements the developer describes are what fields (select elements) the user can see and what data sets (join elements) those fields come from. Each select and join element can depend upon joins. For every Optimal Query there is one driving data set. The driving set does not depend on other data sets. For every row in the driving data set there can only be one corresponding row when joining the driving data set to other joins described in the joins configuration hash reference. This allows Optimal Query to optimize SQL and only include the appropriate joins when the user has selected a column from one of those joins. For example: If there are employee and department tables and the user only wants to see employee fields (not department fields) then Optimal Query will not join in the department table.


%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes LICENSE Todo README
%perl_vendor_privlib/D*
%perl_vendor_privlib/C*

%changelog
