%define module_name CLIPSeqTools
# BEGIN SourceDeps(oneline):
BuildRequires: perl(DBD/SQLite.pm) perl(DBI.pm) perl(Data/Dumper.pm) perl(Data/Table.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Path.pm) perl(File/Spec.pm) perl(GenOO.pm) perl(GenOO/Data/File/FASTQ.pm) perl(GenOO/Data/File/SAM.pm) perl(GenOO/GeneCollection/Factory.pm) perl(GenOO/GenomicRegion.pm) perl(GenOO/RegionCollection/Factory.pm) perl(GenOO/TranscriptCollection/Factory.pm) perl(GenOOx/Data/File/SAMbwa.pm) perl(GenOOx/Data/File/SAMstar.pm) perl(IO/Interactive.pm) perl(List/Util.pm) perl(Modern/Perl.pm) perl(Moose.pm) perl(MooseX/App.pm) perl(MooseX/App/Command.pm) perl(MooseX/App/Role.pm) perl(MooseX/Getopt.pm) perl(PDL.pm) perl(Statistics/R.pm) perl(Try/Tiny.pm) perl(autodie.pm) perl(namespace/autoclean.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.0.0
Release: alt1
Summary: A collection of tools for the analysis of CLIP-Seq data.
Group: Development/Perl
License: perl
URL: https://github.com/mnsmar/clipseqtools

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/M/MN/MNSMAR/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
CLIPSeqTools is primarily a collection of scripts and execuables that can be used for the analysis of CLIP-Seq data.
The tools cover a wide range of analysis, from general statistics like genome coverage to more complex analysis like the relative positioning of reads for two libraries.
The toolbox is under heavy development and new tools are added on a daily basis.

Source code: The source has been deposited in GitHub https://github.com/palexiou/GenOO-CLIP.
Contribute:  Please fork the GitHub repository and provide patches, features or tests.
Bugs:        Please open issues in the GitHub repository https://github.com/palexiou/GenOO-CLIP/issues

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %name = %{?epoch:%epoch:}%version-%release

%description scripts
scripts for %module_name

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE README.md
%perl_vendor_privlib/C*

%files scripts
%_bindir/*

%changelog
