# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    CPAN-Mini-Extract
%define upstream_version 1.24

%{?perl_default_filter}

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt1_1

Summary:    Create CPAN::Mini mirrors with the archives extracted
License:    GPL+ or Artistic
Group:      Development/Perl
Url:        https://metacpan.org/release/%{upstream_name}
Source0:    https://cpan.metacpan.org/modules/by-module/CPAN/%{upstream_name}-%{upstream_version}.tar.gz

BuildRequires: perl(Archive/Tar.pm)
BuildRequires: perl(CPAN/Mini.pm)
BuildRequires: perl(Carp.pm)
BuildRequires: perl(ExtUtils/MakeMaker.pm)
BuildRequires: perl(File/Basename.pm)
BuildRequires: perl(File/Find/Rule.pm)
BuildRequires: perl(File/HomeDir.pm)
BuildRequires: perl(File/Path.pm)
BuildRequires: perl(File/Remove.pm)
BuildRequires: perl(File/Spec.pm)
BuildRequires: perl(File/Spec/Functions.pm)
BuildRequires: perl(File/Temp.pm)
BuildRequires: perl(IO/File.pm)
BuildRequires: perl(IO/Uncompress/Gunzip.pm)
BuildRequires: perl(LWP/Online.pm)
BuildRequires: perl(List/Util.pm)
BuildRequires: perl(Params/Util.pm)
BuildRequires: perl(Test/More.pm)
BuildRequires: perl(URI.pm)
BuildRequires: perl(URI/file.pm)
BuildRequires: perl(strict.pm)
BuildRequires: perl(warnings.pm)
BuildArch:  noarch
Source44: import.info

%description
'CPAN::Mini::Extract' provides a base for implementing systems that
download "all" of CPAN, extract the dists and then process the files
within.

It provides the same synchronisation functionality as CPAN::Mini
except that it also maintains a parallel directory tree that contains a
directory located at an identical path to each archive file, with a
controllable subset of the files in the archive extracted below.

How does it work
    'CPAN::Mini::Extract' starts with a CPAN::Mini local
    mirror, which it will optionally update before each run. Once the
    CPAN::Mini directory is current, it will scan both directory
    trees, extracting any new archives and removing any extracted archives
    no longer in the minicpan mirror.

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor
%make_build CFLAGS="%{optflags}"

%check
make test

%install
%makeinstall_std

%files
%doc CONTRIBUTING Changes INSTALL LICENSE META.json META.yml  README
%perl_vendor_privlib/*

%changelog
