%define module_version 1.21
%define module_name CPAN-Testers-Data-Generator
# BEGIN SourceDeps(oneline):
BuildRequires: perl(CPAN/Testers/Common/Article.pm) perl(CPAN/Testers/Common/DBUtils.pm) perl(CPAN/Testers/Fact/LegacyReport.pm) perl(CPAN/Testers/Fact/TestSummary.pm) perl(CPAN/Testers/Metabase/AWS.pm) perl(CPAN/Testers/Report.pm) perl(Config/IniFiles.pm) perl(DBD/mysql.pm) perl(DBI.pm) perl(Data/FlexSerializer.pm) perl(DateTime.pm) perl(DateTime/Duration.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Basename.pm) perl(File/Path.pm) perl(File/Slurp.pm) perl(Getopt/ArgvFile.pm) perl(Getopt/Long.pm) perl(HTML/Entities.pm) perl(IO/File.pm) perl(JSON.pm) perl(LWP/UserAgent.pm) perl(Metabase.pm) perl(Metabase/Fact.pm) perl(Metabase/Resource.pm) perl(Metabase/Resource/cpan/distfile.pm) perl(Metabase/Resource/metabase/user.pm) perl(Sereal.pm) perl(Test/More.pm) perl(Time/Local.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.21
Release: alt1
Summary: CPAN Testers cpanstats Database Generator
Group: Development/Perl
License: artistic_2
URL: http://devel.cpantesters.org

Source0: http://cpan.org.ua/authors/id/B/BA/BARBIE/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
This distribution was originally written by Leon Brocard to download and
summarize CPAN Testers data. However, all of the original code has been
rewritten to use the CPAN Testers Statistics database generation code. This
now means that all the CPAN Testers sites including the Reports site, the
Statistics site and the CPAN Dependencies site, can use the same database.

This module retrieves and parses reports from the Metabase, generating or
updating entries in the cpanstats database, which extracts specific metadata
from the reports. The information in the cpanstats database is then presented
via CPAN::Testers::WWW::Reports on the CPAN Testers Reports website.

A good example query from the cpanstats database for Acme-Colour would be:

  SELECT version, status, count(*) FROM cpanstats WHERE
  dist = "Acme-Colour" group by version, state;

To create a database from scratch can take several days, as there are now over
24 million submitted reports. As such updating from a known copy of the
database is much more advisable. If you don't want to generate the database
yourself, you can obtain a feed using CPAN::Testers::WWW::Report::Query::Reports.

With over 24 million reports in the database, if you do plan to run this
software to generate the databases it is recommended you utilise a high-end
processor machine. Even with a reasonable processor it can take over a week!

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %name = %{?epoch:%epoch:}%version-%release

%description scripts
scripts for %module_name


%prep
%setup -n %{module_name}-%{module_version}

%build
%perl_vendor_build INSTALLMAN1DIR=%_man1dir

%install
%perl_vendor_install

%files
%doc LICENSE README Changes examples
%perl_vendor_privlib/C*

%files scripts
%_man1dir/*
%_bindir/*

%changelog
