%define module_version 0.21
%define module_name CPAN-Testers-Data-Uploads
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Archive/Extract.pm) perl(Archive/Zip.pm) perl(CPAN/DistnameInfo.pm) perl(CPAN/Testers/Common/Article.pm) perl(CPAN/Testers/Common/DBUtils.pm) perl(Class/Accessor/Fast.pm) perl(Config/IniFiles.pm) perl(DBD/SQLite.pm) perl(DBD/mysql.pm) perl(DBI.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Basename.pm) perl(File/Find/Rule.pm) perl(File/Path.pm) perl(File/Slurp.pm) perl(Getopt/Long.pm) perl(IO/AtomicFile.pm) perl(IO/File.pm) perl(Net/NNTP.pm) perl(Test/More.pm) perl(Test/Trap.pm) perl(base.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.21
Release: alt1
Summary: CPAN Testers Uploads Database Generator
Group: Development/Perl
License: artistic_2
URL: http://devel.cpantesters.org

Source0: http://cpan.org.ua/authors/id/B/BA/BARBIE/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
This program allows the user to create, update and backup the uploads database,
either as separate commands, or a combination of all three. The process order
will always be CREATE->UPDATE->BACKUP, regardless of the order the options
appear on the command line.

The Uploads database contains basic information about the history of CPAN. It
records the release dates of everything that is uploaded to CPAN, both within
a BACKPAN repository, a current CPAN repository and the latest uploads posted
by PAUSE, which may not have yet reached the CPAN mirrors.

A simple schema for the MySQL database is below:

  CREATE TABLE `uploads` (
    `type`      varchar(10)     NOT NULL,
    `author`    varchar(32)     NOT NULL,
    `dist`      varchar(100)    NOT NULL,
    `version`   varchar(100)    NOT NULL,
    `filename`  varchar(255)    NOT NULL,
    `released`  int(16)         NOT NULL,
    PRIMARY KEY  (`author`,`dist`,`version`)
  ) ENGINE=MyISAM;

The 'type' field can be one of three values, 'backpan', 'cpan' or 'upload',
which incates whether the release has been archived to BACKPAN, currently on
CPAN or has recently been uploaded and may not have reached the CPAN mirrors
yet.

The 'author', 'dist', 'version' and 'filename' fields contain the breakdown of
the distribution component parts used to locate the distribution. Although in
most cases the filename could be considered a primary key, it is possible that
two or more authors could upload a distribution with the same name.

The 'released' field holds the date of the distribution release as the number
of seconds since the epoch. This is extremely useful for sorting distributions
based on their release date rather than the version string. Due to many authors
having different version schemes, this is perhaps the only reliable method with
which to sort distribution releases.


%prep
%setup -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes LICENSE README examples
%perl_vendor_privlib/C*

%changelog
