%define module_name CPANSA-DB
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec/Functions.pm) perl(Test/More.pm) perl(YAML/XS.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 20250807.001
Release: alt1
Summary: the CPAN Security Advisory data as a Perl data structure, mostly for CPAN::Audit
Group: Development/Perl
License: artistic_2
URL: https://github.com/briandfoy/cpan-security-advisory

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/B/BR/BRIANDFOY/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
The `db' subroutine returns the CPAN Security Advisory (CPANSA) reports
as a Perl data structure. However, anything can use this.

Each release also comes with a .gpg file that has the signature
for the file. If you cannot confirm that the module file has the
right signature, it might have been corrupted or modified.

This module is available outside of CPAN as a release on GitHub:
https://github.com/briandfoy/cpan-security-advisory/releases.
Each release on GitHub includes an attestation.

There is also a JSON file that provides the same datastructure.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc GPG_README.md SECURITY.md LICENSE README.pod Changes
%perl_vendor_privlib/C*

%changelog
