# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(File/Temp.pm) perl(LWP/Simple.pm) perl(List/Util.pm) perl(Module/CPANTS/Analyse.pm) perl(Module/CPANTS/Kwalitee.pm) perl(Moo.pm) perl(MooX/Options.pm) perl(Parse/CPAN/Packages.pm) perl(Test/More.pm) perl(XML/RSS/Parser.pm) perl(namespace/autoclean.pm)
# END SourceDeps(oneline)
%define module_name CPANTS-Kwalitee-Report
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.11
Release: alt1
Summary: CPANTS Kwalitee Report.
Group: Development/Perl
License: artistic_2
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/M/MA/MANWAR/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This work is  inspired  by the Module::CPANTS::Analyse manpage and  the Test::Kwalitee manpage. The
main objective of this module  is to provide simple API to query Kwalitee scores.

I came across a script `kwalitee-metrics', part of  the Test::Kwalitee manpage, where the
author wish there was an API to do what the author was doing. That prompted me to
begin the journey.

This is what it would look like now, if using this module:

    use strict; use warnings;
    use CPANTS::Kwalitee::Report;

    my $verbose = @ARGV && ($ARGV[0] eq '--verbose' || $ARGV[0] eq '-v');
    my $report  = CPANTS::Kwalitee::Report->new({ verbose => $verbose });

    print sprintf("%%s\n\n", join("\n", @{$report->get_generators}));

Interesting comparison by the Devel::Timer manpage shown below:

    Devel::Timer Report -- Total time: 0.1557 secs
    Interval  Time    Percent
    ----------------------------------------------
    00 -> 01  0.1458  93.62%%  INIT -> old way
    01 -> 02  0.0099   6.38%%  old way -> new way

It comes with a handy  script  `kwalitee-report', which can be used to query the
kwalitee scores of any distribution.

    $ kwalitee-score --dist=Map::Tube

More detailed options shown below:

    $ kwalitee-report -h
    USAGE: kwalitee-report [-hn] [long options...]

         --dist=String              Distribution name to generate Kwalitee
                                    report.
         --metrics                  Show CPANTS Kwalitee metrics.
         --recently_uploaded_dists  Lookup recently uploaded distributions.
         -n=Int                     Distribution count to generate Kwalitee
                                    report. Default is 5.
         --verbose                  Be more descriptive. Default is OFF.

         --usage                    show a short help message
         -h                         show a compact help message
         --help                     show a long help message
         --man                      show the manual

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %name = %EVR

%description scripts
scripts for %module_name

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE Changes README
%perl_vendor_privlib/C*

%files scripts
%_bindir/*

%changelog
