%define module_name CPU-Z80-Disassembler
%define _without_test 1
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Asm/Z80/Table.pm) perl(Bit/Vector.pm) perl(CPU/Z80/Assembler.pm) perl(Class/Accessor.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Slurp.pm) perl(Path/Tiny.pm) perl(Test/More.pm) perl(Test/Output.pm) perl(Tie/File.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.02
Release: alt1
Summary: Disassemble the flow of a Z80 program
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/P/PS/PSCUST/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Implements a Z80 disassembler. Loads a binary file into memory and dumps
an unprocessed disassembly listing (see `write_dump').

Alternatively there are functions to tell the disassembler where there are 
data bytes and what are code entry points and labels. The disassembler will
follow the code by simulating a Z80 processor, to find out where the code region
finishes.

As a `call' instruction may be followed by data, the disassembler tries to find
out if the called routine manipulates the return stack. If it does not, and ends 
with a `ret', then the routine is considered safe, and the disassembly continues
after the `call' instruction. If the routine is not considered safe, a message is 
written at the end of the disassembled file asking the used to check the 
routines manually; the `set_call' method should then be used to tell how to 
handle calls to that routine on the next iteration.

The `analyse' function can be called just before dumping the output to try to find 
higher level constructs in the assembly listing. For example, it transforms the
sequence `ld b,h:ld c,l' into `ld bc,hl'.

The `write_asm' dumps an assembly listing that can be re-assembled to obtain the
starting binary file. All the unknown region bytes are disassembled as `defb' 
instructions, and a map is shown at the end of the file with the code regions (`C'),
byte regions (`B'), word regions (`W') and unknown regions (`-').

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %name = %{?epoch:%epoch:}%version-%release

%description scripts
scripts for %module_name


%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build INSTALLMAN1DIR=%_man1dir

%install
%perl_vendor_install

%files
%doc Changes ARTISTIC.txt README
%perl_vendor_privlib/C*

%files scripts
%_bindir/*

%changelog
