Group: Development/Perl
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(CSS.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           perl-CSS-DOM
Version:        0.17
Release:        alt2_24
Summary:        Document Object Model for Cascading Style Sheets

License:        GPL-1.0-or-later OR Artistic-1.0-Perl
URL:            https://metacpan.org/release/CSS-DOM
Source0:        https://cpan.metacpan.org/authors/id/S/SP/SPROUT/CSS-DOM-%{version}.tar.gz
# Remove apostrophe as package separator - it is deprecated in 5.37.9 and
# will be removed by 5.40. CPAN RT#146661
Patch0:         CSS-DOM-0.17-Dont-use-deprecated-code.patch
BuildArch:      noarch
BuildRequires:  coreutils
BuildRequires:  rpm-build-perl
BuildRequires:  perl-devel
BuildRequires:  perl(ExtUtils/MakeMaker.pm)
BuildRequires:  perl(strict.pm)
# Run-time
BuildRequires:  perl(Carp.pm)
BuildRequires:  perl(Clone.pm)
BuildRequires:  perl(constant.pm)
BuildRequires:  perl(Encode.pm)
BuildRequires:  perl(Exporter.pm)
BuildRequires:  perl(overload.pm)
BuildRequires:  perl(re.pm)
BuildRequires:  perl(Scalar/Util.pm)
BuildRequires:  perl(warnings.pm)
# Tests
BuildRequires:  perl(Test/More.pm)
BuildRequires:  perl(utf8.pm)
# Dependencies not detected automatically:
Requires:       perl(Clone.pm) >= 0.090
Requires:       perl(Encode.pm) >= 2.100


Source44: import.info

%description
This set of modules provides the CSS-specific interfaces described in
the W3C DOM recommendation.


%prep
%setup -q -n CSS-DOM-%{version}
%patch0  -p1


%build
perl Makefile.PL INSTALLDIRS=vendor NO_PACKLIST=1
%make_build


%install
make pure_install DESTDIR=$RPM_BUILD_ROOT
# %{_fixperms} $RPM_BUILD_ROOT/*


%check
make test


%files
%doc Changes README
%doc --no-dereference LICENSE
%{perl_vendor_privlib}/CSS/


%changelog
