# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(IO/Handle.pm) perl(IPC/Open3.pm) perl(List/MoreUtils.pm) perl(Moo.pm) perl(Path/Tiny.pm) perl(Test/CheckDeps.pm) perl(Test/More.pm) perl(Test/Warnings.pm) perl(Text/CSV.pm) perl(namespace/clean.pm)
# END SourceDeps(oneline)
%define module_name CSV-HistoryPlayer
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.03
Release: alt1
Summary: Plays scattered CSV files with historic data
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/B/BI/BINARY/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Let's assume you have many of CSV-files, each one has some events
written in it (in the first column in form of unix timestamp) and
filenames also have encoded date of the events within, i.e.

 .i'.ie.ie income
 .i'-o-o .i'.ie.ie 2015-02-10.csv
 .i'-o-o .ii.ie.ie 2015-02-12.csv
 .ii.ie.ie outcome
     .i'.ie.ie 2015-02-11.csv
     .ii.ie.ie 2015-02-12.csv

Let's assume, that the files have content like:

 income/2015-02-10.csv: 1455106611, 10, "got pocket money from Mom"
 income/2015-02-12.csv: 1455301001, 15, "got pocket money from Dad"
 outcome/2015-02-11.csv: 1455203801, 10, "bought Immortal CD (black metal)"
 outcome/2015-02-12.csv: 1455307400, 10, "bought Obsidian Gate CD (black metal)"

Now, you would to replay all transactions. That's easy

  use CSV::HistoryPlayer;

  my $player = CSV::HistoryPlayer->(root_dir => 'path/to/directory');
  while (my $data = $player->poll) {
    my ($file, $row) = @$data;
    my ($when, $how_much, $description) = @$row;
    my $sign = $file =~ /income/ ? '+' : '-';
    print $sign, " ", $how_much, '$: ', $description, "\n";
  }

  # +10$: got pocket money from Mom
  # -10$: bought Immortal CD (black metal)
  # +15$: got pocket money from Dad
  # -10$: bought Obsidian Gate CD (black metal)

I.e. the the CSV::HistoryPlayer manpage virtually unites scattered CSV files,
and allows to read evens from them in historically correct order.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE README README.md Changes
%perl_vendor_privlib/C*

%changelog
