%define module_name CVSS
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(JSON/PP.pm) perl(List/Util.pm) perl(Pod/Usage.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.14
Release: alt1
Summary: Perl extension for CVSS (Common Vulnerability Scoring System) 2.0/3.x/4.0
Group: Development/Perl
License: artistic_2
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/G/GD/GDT/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module calculates the CVSS (Common Vulnerability Scoring System) scores
(basic, temporal, and environmental), convert the "vector string" and returns
the the CVSS manpage object in JSON or XML.

The Common Vulnerability Scoring System (CVSS) provides a way to capture the
principal characteristics of a vulnerability and produce a numerical score
reflecting its severity. The numerical score can then be translated into a
qualitative representation (such as low, medium, high, and critical) to help
organizations properly assess and prioritize their vulnerability management
processes.

https://www.first.org/cvss/

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %name = %EVR

%description scripts
scripts for %module_name

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc INSTALL.md Changes LICENSE README.md
%perl_vendor_privlib/A*
%perl_vendor_privlib/C*

%files scripts
%_man1dir/*
%_bindir/*

%changelog
