# BEGIN SourceDeps(oneline):
BuildRequires: perl(CPAN.pm) perl(Class/MOP.pm) perl(Config.pm) perl(Cwd.pm) perl(Data/GUID.pm) perl(Dir/Self.pm) perl(Directory/Scratch.pm) perl(ExtUtils/MM_Unix.pm) perl(ExtUtils/MakeMaker.pm) perl(ExtUtils/Manifest.pm) perl(Fcntl.pm) perl(File/BaseDir.pm) perl(File/Basename.pm) perl(File/Find.pm) perl(File/MimeInfo/Magic.pm) perl(FileHandle.pm) perl(FindBin.pm) perl(JSON.pm) perl(LWP/Simple.pm) perl(Module/Build.pm) perl(Moose.pm) perl(MooseX/Types/Data/GUID.pm) perl(MooseX/Types/Path/Class.pm) perl(Net/FTP.pm) perl(Parse/CPAN/Meta.pm) perl(Path/Class.pm) perl(Scalar/Util.pm) perl(Socket.pm) perl(Sub/Exporter.pm) perl(Test/Fatal.pm) perl(Test/More.pm) perl(Try/Tiny.pm) perl(YAML/Tiny.pm) perl(inc/Module/Install.pm) perl(namespace/autoclean.pm)
# END SourceDeps(oneline)
%define module_version 0.003003
%define module_name Cantella-Store-UUID
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.003003
Release: alt1
Summary: UUID based file storage
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/A/AR/ARCANEZ/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
the Cantella::Store::UUID manpage stores documents in a deterministic location based on
a UUID. Depending on the number of files to be stored, a store may use 1
or more levels. A level is composed of 16 directories (0-9 and A-F) nested to
`n' depth. For Example, if a store has 3 levels, the path to file represented
by UUID `A5D45AF2-73D1-11DD-AA18-4B321EADD46B' would be
`A/5/D/A5D45AF2-73D1-11DD-AA18-4B321EADD46B'.

The goal is to provide a simple way to spread the storage  of a large number of
files over many directories to prevent any single directory from storing too-many
files. Optionally, lower level tools can then be utilized to spread the
underlying storage points accross different physical devices if necessary.

The number of final storage points available can be calculated by raising 16 to
the nth power, where n is the number of `nest levels'.

Caution: The number of directories generated is actually larger than the
number of final storage points because all directories in the hierarchy must
be counted, thus the number of directories a store contains is
`(16^n) + (16^(n-1)) .. (16^1) + (16^0)' and a 5 level deep hierarchy for
all three storage points would create 3,355,443 directories. For this reason,
any number larger than 4 is cautioned against.


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/C*

%changelog
