# BEGIN SourceDeps(oneline):
BuildRequires: perl(Beanstalk/Client.pm) perl(CPAN.pm) perl(Config.pm) perl(Cwd.pm) perl(ExtUtils/MM_Unix.pm) perl(ExtUtils/MakeMaker.pm) perl(ExtUtils/Manifest.pm) perl(File/Basename.pm) perl(File/Find.pm) perl(FileHandle.pm) perl(JSON.pm) perl(LWP/Simple.pm) perl(List/Util.pm) perl(Log/Dispatch.pm) perl(Module/Build.pm) perl(Moose.pm) perl(Moose/Role.pm) perl(MooseX/Types/Common/Numeric.pm) perl(Net/FTP.pm) perl(Parse/CPAN/Meta.pm) perl(Socket.pm) perl(Test/Most.pm) perl(YAML/Tiny.pm) perl(inc/Module/Install.pm) perl(Cantella/Worker/Role/Worker.pm)
# END SourceDeps(oneline)
%define module_version 0.001000
%define module_name Cantella-Worker-Role-Beanstalk
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.001000
Release: alt1
Summary: Fetch Cantella::Worker jobs from beanstalkd
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/G/GR/GRODITI/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
package TestWorkerPool;.
    use Try::Tiny;
    use Moose;
    with(
      'Cantella::Worker::Role::Worker',
      'Cantella::Worker::Role::Beanstalk'
    );

    sub work {
      my ($self, $job) = @_;
      my @args = $job->args;
      try {
        if( do_something(@args) ){
          $job->delete; #work done successfully
        } else {
          $job->release({delay => 10}); #let's try again in 10 seconds
        }
      } catch {
        $job->bury; #job failed, bury it and log to file
        $self->logger->error("Burying job ".$job->id." due to error: '$_'");
      };
    }



%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/C*

%changelog
