# BEGIN SourceDeps(oneline):
BuildRequires: capstone libsowing-devel perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(XSLoader.pm) pkgconfig(capstone)
# END SourceDeps(oneline)
%define module_name Capstone
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.7
Release: alt6
Summary: Perl extension for capstone-engine
Group: Development/Perl
License: gpl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/T/TO/TOSH/%{module_name}-%{version}.tar.gz

%description
This module is a Perl wrapper of the capstone-engine library.

Capstone is a disassembly framework with the target of becoming the ultimate
disasm engine for binary analysis and reversing in the security community.

Created by Nguyen Anh Quynh, then developed and maintained by a small community,
Capstone offers some unparalleled features:

- Support multiple hardware architectures: ARM, ARM64 (ARMv8), Mips, PPC, Sparc,
  SystemZ, XCore and X86 (including X86_64).

- Having clean/simple/lightweight/intuitive architecture-neutral API.

- Provide details on disassembled instruction (called \u201cdecomposer\u201d by others).

- Provide semantics of the disassembled instruction, such as list of implicit
  registers read & written.

- Implemented in pure C language, with lightweight wrappers for C++, C#, Go,
  Java, Lua, NodeJS, Ocaml, Python, Ruby, Rust & Vala ready (available in
  main code, or provided externally by the community).

- Native support for all popular platforms: Windows, Mac OSX, iOS, Android,
  Linux, *BSD, Solaris, etc.

- Thread-safe by design.

- Special support for embedding into firmware or OS kernel.

- High performance & suitable for malware analysis (capable of handling various
  X86 malware tricks).

- Distributed under the open source BSD license.

Further information is available at http://www.capstone-engine.org

%prep
%setup -q -n %{module_name}-%{version}
[ %version = 0.7 ] && rm t/Capstone.t

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE CHANGES README
%perl_vendor_archlib/C*
%perl_vendor_autolib/*

%changelog
