%define module_name Carp-Proxy
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Config.pm) perl(Cwd.pm) perl(English.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Basename.pm) perl(File/Spec/Functions.pm) perl(Moose.pm) perl(Pod/Coverage.pm) perl(Readonly.pm) perl(Sub/Name.pm) perl(Test/Exception.pm) perl(Test/More.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(YAML/XS.pm) perl(overload.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.16
Release: alt1
Summary: Diagnostic delegation
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/T/TH/THAIRMAN/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Error messages in Perl are commonly coded with idioms like:

    die 'explanation'
        if not $assertion;

The idiom is attractive when the explanation is simple.  If an
explanation grows to more than a few words, or if it requires
calculation, then the surrounding flow becomes disrupted.  The
solution, of course, is to offload failing assertions to a subroutine.

Subroutines that perform diagnosis, compose error messages and throw
exceptions tend to have repeated code at the beginning and end, with
unique content somewhere in the middle.  Carp::Proxy proposes a
wrapper subroutine, called a Proxy, to factor out the repeated sections.

    fatal 'user_subroutine'
        if not $assertion;

Proxys, like fatal(), serve as elaborate, customizable replacements
for warn(), die() and members of the Carp:: family like
confess().  If we look at warn(), die(), confess() and the like,
we notice that they are all just different variations on two themes:

    - Add locational context to a user-supplied message.
    - Throw some kind of exception.

Carp::Proxy parameterizes the two themes into attributes of an
exception object that is created whenever a Proxy is called.  The
Proxy passes the object to a user-defined "Handler" subroutine which
is responsible for constructing the diagnostic message.  When the
Handler returns, the Proxy optionally adds "Context" (a stacktrace) to
the message and performs "Disposition", typically by calling die().

When the object is constructed it captures the state of Perl's error
variables, for later examination by the Handler.  The object provides
methods that aid in message composition.  Attributes control message
formatting, stacktrace generation and how Disposition will be handled.

The object overloads Perl's stringification operator with a message
rendering method, causing uncaught exceptions to be nicely formatted.
Exceptions that are caught can be modified and re-thrown.
%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes ignore.txt README
%perl_vendor_privlib/C*

%changelog
