# BEGIN SourceDeps(oneline):
BuildRequires: perl(CPAN.pm) perl(Catalyst/Exception.pm) perl(Config.pm) perl(Cwd.pm) perl(ExtUtils/MM_Unix.pm) perl(ExtUtils/MakeMaker.pm) perl(ExtUtils/Manifest.pm) perl(Fcntl.pm) perl(File/Basename.pm) perl(File/Find.pm) perl(FileHandle.pm) perl(HTTP/Request/Common.pm) perl(LWP/UserAgent.pm) perl(Module/Build.pm) perl(Moose.pm) perl(MooseX/Types/Common/String.pm) perl(MooseX/Types/Moose.pm) perl(Net/OAuth.pm) perl(String/Random.pm) perl(Test/More.pm) perl(YAML/Tiny.pm) perl(namespace/autoclean.pm)
# END SourceDeps(oneline)
%define module_version 0.04
%define module_name Catalyst-Authentication-Credential-OAuth
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.04
Release: alt1
Summary: OAuth credential for Catalyst::Plugin::Authentication framework.
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/B/BO/BOBTFISH/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
In MyApp.pm

    use Catalyst qw/
        Authentication
        Session
        Session::Store::FastMmap
        Session::State::Cookie
    /;


In myapp.conf

    <Plugin::Authentication>
        default_realm	oauth
        <realms>
            <oauth>
                <credential>
                    class	OAuth
                    <providers>
                        <example.com>
                            consumer_key             my_app_key
                            consumer_secret          my_app_secret
                            request_token_endpoint   http://example.com/oauth/request_token
                            access_token_endpoint    http://example.com/oauth/access_token
                            user_auth_endpoint       http://example.com/oauth/authorize
                        </example.com>
                    </providers>
                </credential>
            </oauth>
        </realms>
    </Plugin::Authentication>


In controller code,

    sub oauth : Local {
        my ($self, $c) = @_;

        if( $c->authenticate( { provider => 'example.com' } ) ) {
            #do something with $c->user
        }
    }




%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc .git/description Changes README
%perl_vendor_privlib/C*

%changelog
