# BEGIN SourceDeps(oneline):
BuildRequires: perl(CPAN.pm) perl(Config.pm) perl(Cwd.pm) perl(ExtUtils/MM_Unix.pm) perl(ExtUtils/MakeMaker.pm) perl(ExtUtils/Manifest.pm) perl(File/Basename.pm) perl(File/Find.pm) perl(FileHandle.pm) perl(JSON.pm) perl(LWP/Simple.pm) perl(Module/Build.pm) perl(Moose.pm) perl(Net/FTP.pm) perl(Parse/CPAN/Meta.pm) perl(Socket.pm) perl(Test/More.pm) perl(YAML/Tiny.pm) perl(inc/Module/Install.pm) perl(Catalyst/Authentication/Realm.pm)
# END SourceDeps(oneline)
%define module_version 0.02
%define module_name Catalyst-Authentication-Realm-Adaptor
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.02
Release: alt1
Summary: Adjust parameters of authentication processes on the fly
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/F/FL/FLORA/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
The Catalyst::Authentication::Realm::Adaptor allows for modification of.authentication parameters within the catalyst application. It's basically a
filter used to adjust authentication parameters globally within the
application or to adjust user retrieval parameters provided by the credential
in order to be compatible with a different store. It provides for better
control over interaction between credentials and stores. This is particularly
useful when working with external authentication such as OpenID or OAuth.

 __PACKAGE__->config(
    'Plugin::Authentication' => {
            'default' => {
                class => 'Adaptor'
                credential => {
                    class => 'Password',
                    password_field => 'secret',
                    password_type  => 'hashed',
                    password_hash_type => 'SHA-1',
                },
                store => {
                    class      => 'DBIx::Class',
                    user_class => 'Schema::Person',
                },
                store_adaptor => {
                    method => 'merge_hash',
                    merge_hash => {
                        status => [ 'temporary', 'active' ]
                    }
                }
            },
        }
    }
 );


The above example ensures that no matter how $c->authenticate() is called
within your application, the key 'status' is added to the authentication hash.
This allows you to, among other things, set parameters that should always be
applied to your authentication process or modify the parameters to better
connect a credential and a store that were not built to work together. In the
above example, we are making sure that the user search is restricted to those
with a status of either 'temporary' or 'active.'

This realm works by intercepting the original authentication information
between the time `$c->authenticate($authinfo)' is called and the time the
realm's `$realm->authenticate($c,$authinfo)' method is called, allowing for
the $authinfo parameter to be modified or replaced as your application
requires. It can also operate after the call to the credential's
`authenticate()' method but before the call to the store's `find_user'
method.

If you don't know what the above means, you probably do not need this module.


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/C*

%changelog
