# BEGIN SourceDeps(oneline):
BuildRequires: perl(App/Cmd/Simple.pm) perl(Catalyst.pm) perl(Catalyst/Controller.pm) perl(Catalyst/Model/DBIC/Schema.pm) perl(Catalyst/ScriptRunner.pm) perl(Class/Load.pm) perl(DBIx/Class/Core.pm) perl(DBIx/Class/Schema.pm) perl(DBIx/Class/Schema/Loader.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec/Functions.pm) perl(FindBin.pm) perl(IPC/Open2.pm) perl(JSON/MaybeXS.pm) perl(Modern/Perl.pm) perl(Module/Runtime.pm) perl(Moose.pm) perl(YAML/Syck.pm) perl(aliased.pm) perl(base.pm) perl(rlib.pm)
# END SourceDeps(oneline)
%define module_name Catalyst-Authentication-RedmineCookie
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.02
Release: alt1
Summary: Decode the redmine cookie _redmine_session
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/B/BO/BOKUTIN/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
package TestApp;
    use base qw(Catalyst);
    __PACKAGE__->config(
        'Plugin::Authentication' => {
            default_realm => 'redmine_cookie',
            realms => {
                redmine_cookie => {
                    credential => {
                        class => 'RedmineCookie',
                        # examples
                        cmd   => [qw(ssh redmine.server rails4_cookie_to_json.rb)],
                        cmd   => [qw(sudo jexec redmine rails4_cookie_to_json.rb)],
                    },
                    # It does not specify a store, it works with NullStore.
                    store => {
                        class => 'DBIx::Class',
                        user_model => 'DBIC::Users',
                    }
                },
            },
        },
        # Not required for NullStore.
        'Model::DBIC' => {
            schema_class => "Catalyst::Authentication::RedmineCookie::Schema",
            compose_namespaces => 0,
            connect_info => [
                "DBI:mysql:database=redmine", 'user', 'pass',
                {
                    RaiseError        => 1,
                    PrintError        => 0,
                    AutoCommit        => 1,
                    pg_enable_utf8    => 1, # for pg
                    mysql_enable_utf8 => 1, # for mysql
                    quote_names       => 1,
                }
            ],
        },
    );
    __PACKAGE__->setup(
        'Authentication',
    );

    package TestApp::Controller::Root;
    use base qw(Catalyst::Controller);
    sub index :Path('/') {
        my ($self, $c) = @_;

        $c->authenticate;

        # If the store is Null
        if ($c->user) {
            ref $c->user;             # Catalyst::Authentication::User::Hash
            ref YAML::Syck::Dump($c->user);

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%perl_vendor_privlib/C*

%changelog
