# BEGIN SourceDeps(oneline):
BuildRequires: perl(CPAN.pm) perl(Carp.pm) perl(Catalyst.pm) perl(Catalyst/Component.pm) perl(Catalyst/Controller.pm) perl(Catalyst/Model.pm) perl(Catalyst/Test.pm) perl(Catalyst/View.pm) perl(Config.pm) perl(Cwd.pm) perl(Devel/Cycle.pm) perl(ExtUtils/MM_Unix.pm) perl(ExtUtils/MakeMaker.pm) perl(ExtUtils/Manifest.pm) perl(File/Basename.pm) perl(File/Find.pm) perl(File/Spec.pm) perl(FileHandle.pm) perl(FindBin.pm) perl(JSON.pm) perl(LWP/Simple.pm) perl(MRO/Compat.pm) perl(Module/Build.pm) perl(Moose.pm) perl(Net/FTP.pm) perl(Parse/CPAN/Meta.pm) perl(Scalar/Util.pm) perl(Socket.pm) perl(Test/More.pm) perl(YAML/Tiny.pm) perl(base.pm) perl(inc/Module/Install.pm)
# END SourceDeps(oneline)
%define module_version 0.07
%define module_name Catalyst-Component-ACCEPT_CONTEXT
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.07
Release: alt1
Summary: Make the current Catalyst
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/B/BO/BOBTFISH/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
Models and Views don't usually have access to the request object,
since they probably don't really need it.  Sometimes, however, having
the request context available outside of Controllers makes your
application cleaner.  If that's the case, just use this module as a
base class:

    package MyApp::Model::Foobar;
    use base qw|Catalyst::Component::ACCEPT_CONTEXT Catalyst::Model|;

Then, you'll be able to get the current request object from within
your model:

    sub do_something {
        my $self = shift;
        print "The current URL is ". $self->context->req->uri->as_string;
    }


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/C*

%changelog
