%define module_name Catalyst-Controller-Public
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Catalyst.pm) perl(Catalyst/ActionRole/Public.pm) perl(Catalyst/Test.pm) perl(ExtUtils/MakeMaker.pm) perl(FindBin.pm) perl(Moose.pm) perl(MooseX/MethodAttributes.pm) perl(Test/Most.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.004
Release: alt1
Summary: A Public file serving Catalyst Controller
Group: Development/Perl
License: perl
URL: https://github.com/jjn1056/Catalyst-Controller-Public

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/J/JJ/JJNAPIORK/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Note: This class just extends the Catalyst::ControllerRole::Public manpage.  All the main
code is in that role.  You can do the same if it makes sense based on your programming
organization needs.

I prefer to have a controller to manage public assets since I like to use $c->uri_for
and similar to construct paths.  Out of the box this controller does what I think is
the mostly right thing, which is it serves public assets using something like
the Plack::App::Directory manpage or the Plack::App::File manpage (if I am in production or not)
from $HOME/root/${controller-namespace} and it also makes it easy to create private
paths to public URLs in the way that makes sense to you.

If you inherit from this you will get a public URL endpoint which is the same as the
controller's namespace.  That will serve files under your `public_path', which just
defaults as already described.

Althought this controller offers some configuration and features, unlike more complex
systems (see the Catalyst::Controller::Assets manpage for example) we do not attempt to full
on 'Rails Asset pipeline' approach, such as building LESS to css or compiling CoffeeScript
to Javascript.  The intention here is to be simple enough for people to use it with
out a lot of documentation pondering.  Also in my experience Javascript developers and
designers prefer to use there own tools and code generation pipelines, over any that
comes bundled with the Catalyst manpage (just an observation).  As a result this is aimed at
serving up files that are ready to go.  The assumption is that your Javascript and designers
will use their desired tools and build static versions of thier code into the correct
directory.
%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README README.mkdn LICENSE Changes
%perl_vendor_privlib/C*

%changelog
