%define module_name Catalyst-ControllerPerContext
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Catalyst.pm) perl(Catalyst/Test.pm) perl(Encode.pm) perl(ExtUtils/MakeMaker.pm) perl(Moose.pm) perl(String/CamelCase.pm) perl(Test/Most.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.006
Release: alt1
Summary: Map body and data parameters to a model
Group: Development/Perl
License: perl
URL: https://github.com/jjn1056/Catalyst-ControllerPerContext

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/J/JJ/JJNAPIORK/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Classic the Catalyst::Controller manpages are application scoped, which means we create an instance of the
controller when the application starts as a singleton instance, which is reused for all request
going forward.  This has the lowest overhead.   However it makes it hard to do things like use
controller attributes since those attributes get shared for all requests.  By changing to creating
a new controller for each request you can then use those attributes.

This for the most part is nothing you couldn't do with the stash but has the upside of avoiding
the stash typo bugs you see a lot and also the stash is shared for the entire context so stuff
you stuff in there might be too broadly accessible, whereas data in controller attributes is 
scoped to the controller only.

I consider this an experimental release to let interested people (including myself) to play with 
the idea of per context controllers and see if it leads to new approaches and better code.  Please
be warned that the code under the hood here is a bit of a hack up due to how we added some features
to Controller over time that made the assumption that an attribute is application scoped (such as
how we merged the action role support many years ago).  If this turns out to be a good idea we'll
need to make deeper fixes to the base the Catalyst::Controller manpage to make this right.   As a result of
this hacking I can't be sure this controller will be a drop in replacement everywhere, especially
if you've doing a ton of customization to the base controller code in a custom controller subclass.

In order to emphasize the magnitude of this crime / hack there's not really many test cased ;)

Some of the things I'm using this to experiement with is using controller attributes to define
a stronger API between the controller and its views and using controller attributes as proxies
for the models a controller works with.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE README.mkdn Changes README
%perl_vendor_privlib/C*

%changelog
