%define module_name Catalyst-ControllerRole-At
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Catalyst.pm) perl(Catalyst/ActionRole/NamedFields.pm) perl(Catalyst/ActionRole/QueryParameter.pm) perl(Catalyst/Test.pm) perl(ExtUtils/MakeMaker.pm) perl(HTTP/Request/Common.pm) perl(Moose.pm) perl(MooseX/MethodAttributes.pm) perl(Test/Most.pm) perl(Types/Standard.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.008
Release: alt1
Summary: Alternative syntax for describing Catalyst routes
Group: Development/Perl
License: perl
URL: https://github.com/jjn1056/Catalyst-ControllerRole-At

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/J/JJ/JJNAPIORK/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
The way the Catalyst manpage uses method attributes to annote a subroutine with meta
information used to map that action to an incoming request has sometimes been difficult
for newcomers to the framework.  Partly this is due to how the system evolved and was
augmented, with more care towards backwards compatibility (for example with the Maypole manpage, its
architectural anscestor) than with designing a forward system that is easy to grasp.
Additionally aspects of the system such as chained dispatch are very useful in the
hands of an expert but the interface leaves a lot to be desired.  For example it is
possible to craft actions that mix chaining syntax with 'classic' syntax in ways that
are confusing.  And having more than one way to do the same thing without clear and
obvious benefits is confusing to newcomers.

Lastly, the core the Catalyst::Controller manpage syntax has confusing defaults that are not readily guessed.
For example do you know the difference (if any) between Args and Args()?  Or the difference
between Path, Path(''), and Path()?  In many cases defaults are applied that were not
intended and things that you might think are the same turn out to have different effects.  All
this conspires to worsen the learning curve.

This role defines an alternative syntax that we hope is easier to understand and for the most
part eliminates defaults and guessed intentions.  It only defines two method attributes, "At()"
and "Via()", which have no defaults and one of which is always required.  It also smooths
over differences between 'classic' route matching using :Local and :Path and the newer
syntax based on Chaining by providing a single approach that bridges between the two
styles.  One can mix and match the two without being required to learn a new syntax or to
rearchitect the system.

The "At()" syntax more closely resembles the type of URL you are trying to match, which should
make code creation and maintainance easier by reducing the mental mismatch that happens with
the core syntax.

Ultimately ...
%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes README.mkdn LICENSE
%perl_vendor_privlib/C*

%changelog
